/*
 * Copyright (C) 2012  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef COMPROVAFIGURES_H
#define COMPROVAFIGURES_H


#include <QDialog>
#include <QtGui>

#include "peca/conjuntpeces.h"
#include "comuns/constants.h"
#include "comuns/configuracio.h"



class ComprovaFigures : public QDialog
{
    Q_OBJECT

public:
    ComprovaFigures(Configuracio *configJoc, QWidget *parent = 0);

    //Per mostrar les figures del programa
    QGraphicsScene *sceneFiguresPrograma;
    QGraphicsView *viewFiguresPrograma;

    //Per mostrar les figures noves
    QGraphicsScene *sceneFiguresNoves;
    QGraphicsView *viewFiguresNoves;

    //Per fer la comprovació de figures
    QGraphicsScene *sceneComparacio;
    QGraphicsView *viewComparacio;

    QLabel *labelFiguraPrograma;
    QLabel *labelFiguresGenerades;
    QLabel *labelTemps;
    QFrame *botonsFrame;

    QPushButton *tanca ;
    QPushButton *obreFiguresGenerades;
    QPushButton *comparaFiguresPrograma;
    QPushButton *comparaFiguresGenerades;
    QPushButton *figuraAnteriorButton;
    QPushButton *figuraSeguentButton;
    QPushButton *eliminaFigura;
    QPushButton *desaCanvis;
    QPushButton *canviaNumeracio;

    QPushButton *desaLlistaComparacio;

    QProgressDialog *progresCercaFigura;

    QTreeWidget *arbreFiguresTreeWidget;
    QTreeWidget *arbreNovesFiguresTreeWidget;

    ConjuntPeces *conjuntMostraPrograma;
    ConjuntPeces *conjuntMostraNovesFigures;


    //Figura que es busca (de les figures generades)
    ConjuntPeces *conjuntComparacioOriginal;
    //Figura amb la qual es compara
    ConjuntPeces *conjuntComparacioComparada;

    Configuracio *configuracioJoc;

    QString charPathSeparator;
    //Rellotge per controlar el temps
    //de recerca de les figures
    QTime tempsComparacioFigures;

private slots:
    /*
     Gestiona la selecció d'una figura a l'arbre
     (conectat amb arbreFiguresTreeWidget::itemSelectionChanged ()
    */
    void seleccioFiguraJoc();
    void seleccioFiguraNova();
    QString seleccioFigura(QTreeWidget *arbre);

    //botons
    void obreFiguresGeneradesSlot();
    //busca les figures generades entre
    //les figures del programa
    void comparaFiguresProgramaSlot();


    void figuraSeguentSlot();
    void figuraAnteriorSlot();
    void eliminaFiguraSlot();
    void desaCanvisSlot();
    void canviaNumeracioFiguresGeneradesSlot();

    //busca les figures generades entre
    //les figures generades
    void comparaFiguresGeneradesSlot();
    void activaBotonsMovimentLlistaComparacioFigures();
    void desaDadesCercaFigures();
    void tancaSlot();
    void desaLlistaComparacioSlot();

private:



    //Carrega les figures als arbres
    void carregaArbreFigures(QTreeWidget *arbre, QString nomArxiu, bool traduc=true);
    void llegeixArxiuFigures(QTreeWidget *arbre, QString nomArxiu, bool traduc);
    QString nomArxiuFiguresGeneradesPredeterminat();


    void cercaFigura(int indexOriginal,int arbreComparacio,QTreeWidget *arbreCerca, int itemInici=0);
    float figuraSolucionada();

    /*
      Compara les siluetes dels conjunts per saber
      si poden ésser semblants
      */
    bool comparacioLongitudSiluetes();

    /*
      Compara les siluetes directament
      */
    bool comparacioSiluetes();
    bool siluetesIntersecten();

    void afegeixFiguraSemblant(int indexOriginal,int indexComparada,
                               int arbreComparacio, float percentatge);

    void activaLabelsFiguresSemblants(bool activa=false);
    void activaConjuntsFigures(bool activa=false);


    void mostraFiguraSemblant(int index);
    int indexLlistaFiguraSemblant;
    QStringList *figuresSemblantsList;
    /*
      Genera tots els conjunts de peces
      per mostrar les figures
      */
    void generaConjunts(int tipusTangram);

    void actualitzaTextItemArrel();

    void tradueixGUI();

    void missatgeEstimacioTemps(int figuresFetes, int total, int temps);


};

#endif // COMPROVAFIGURES_H
