// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appsync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a DataSource object.
func (c *Client) UpdateDataSource(ctx context.Context, params *UpdateDataSourceInput, optFns ...func(*Options)) (*UpdateDataSourceOutput, error) {
	if params == nil {
		params = &UpdateDataSourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDataSource", params, optFns, c.addOperationUpdateDataSourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDataSourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDataSourceInput struct {

	// The API ID.
	//
	// This member is required.
	ApiId *string

	// The new name for the data source.
	//
	// This member is required.
	Name *string

	// The new data source type.
	//
	// This member is required.
	Type types.DataSourceType

	// The new description for the data source.
	Description *string

	// The new Amazon DynamoDB configuration.
	DynamodbConfig *types.DynamodbDataSourceConfig

	// The new OpenSearch configuration.
	//
	// As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch
	// Service. This configuration is deprecated. Instead, use UpdateDataSourceRequest$openSearchServiceConfigto update an OpenSearch
	// data source.
	ElasticsearchConfig *types.ElasticsearchDataSourceConfig

	// The new Amazon EventBridge settings.
	EventBridgeConfig *types.EventBridgeDataSourceConfig

	// The new HTTP endpoint configuration.
	HttpConfig *types.HttpDataSourceConfig

	// The new Lambda configuration.
	LambdaConfig *types.LambdaDataSourceConfig

	// Enables or disables enhanced data source metrics for specified data sources.
	// Note that metricsConfig won't be used unless the dataSourceLevelMetricsBehavior
	// value is set to PER_DATA_SOURCE_METRICS . If the dataSourceLevelMetricsBehavior
	// is set to FULL_REQUEST_DATA_SOURCE_METRICS instead, metricsConfig will be
	// ignored. However, you can still set its value.
	//
	// metricsConfig can be ENABLED or DISABLED .
	MetricsConfig types.DataSourceLevelMetricsConfig

	// The new OpenSearch configuration.
	OpenSearchServiceConfig *types.OpenSearchServiceDataSourceConfig

	// The new relational database configuration.
	RelationalDatabaseConfig *types.RelationalDatabaseDataSourceConfig

	// The new service role Amazon Resource Name (ARN) for the data source.
	ServiceRoleArn *string

	noSmithyDocumentSerde
}

type UpdateDataSourceOutput struct {

	// The updated DataSource object.
	DataSource *types.DataSource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDataSourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDataSource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDataSource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDataSource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDataSourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDataSource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDataSource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDataSource",
	}
}
