// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The configuration based on which FinSpace will scale in or scale out nodes in
// your cluster.
type AutoScalingConfiguration struct {

	//  The metric your cluster will track in order to scale in and out. For example,
	// CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all the nodes in a
	// cluster.
	AutoScalingMetric AutoScalingMetric

	// The highest number of nodes to scale. This value cannot be greater than 5.
	MaxNodeCount *int32

	// The desired value of the chosen autoScalingMetric . When the metric drops below
	// this value, the cluster will scale in. When the metric goes above this value,
	// the cluster will scale out. You can set the target value between 1 and 100
	// percent.
	MetricTarget *float64

	// The lowest number of nodes to scale. This value must be at least 1 and less
	// than the maxNodeCount . If the nodes in a cluster belong to multiple
	// availability zones, then minNodeCount must be at least 3.
	MinNodeCount *int32

	// The duration in seconds that FinSpace will wait after a scale in event before
	// initiating another scaling event.
	ScaleInCooldownSeconds *float64

	// The duration in seconds that FinSpace will wait after a scale out event before
	// initiating another scaling event.
	ScaleOutCooldownSeconds *float64

	noSmithyDocumentSerde
}

// A structure for the metadata of a cluster. It includes information like the
// CPUs needed, memory of instances, and number of instances.
type CapacityConfiguration struct {

	// The number of instances running in a cluster.
	NodeCount *int32

	// The type that determines the hardware of the host computer used for your
	// cluster instance. Each node type offers different memory and storage
	// capabilities. Choose a node type based on the requirements of the application or
	// software that you plan to run on your instance.
	//
	// You can only specify one of the following values:
	//
	//   - kx.s.large – The node type with a configuration of 12 GiB memory and 2 vCPUs.
	//
	//   - kx.s.xlarge – The node type with a configuration of 27 GiB memory and 4
	//   vCPUs.
	//
	//   - kx.s.2xlarge – The node type with a configuration of 54 GiB memory and 8
	//   vCPUs.
	//
	//   - kx.s.4xlarge – The node type with a configuration of 108 GiB memory and 16
	//   vCPUs.
	//
	//   - kx.s.8xlarge – The node type with a configuration of 216 GiB memory and 32
	//   vCPUs.
	//
	//   - kx.s.16xlarge – The node type with a configuration of 432 GiB memory and 64
	//   vCPUs.
	//
	//   - kx.s.32xlarge – The node type with a configuration of 864 GiB memory and 128
	//   vCPUs.
	NodeType *string

	noSmithyDocumentSerde
}

// A list of change request objects.
type ChangeRequest struct {

	// Defines the type of change request. A changeType can have the following values:
	//
	//   - PUT – Adds or updates files in a database.
	//
	//   - DELETE – Deletes files in a database.
	//
	// This member is required.
	ChangeType ChangeType

	// Defines the path within the database directory.
	//
	// This member is required.
	DbPath *string

	// Defines the S3 path of the source file that is required to add or update files
	// in a database.
	S3Path *string

	noSmithyDocumentSerde
}

// The structure of the customer code available within the running cluster.
type CodeConfiguration struct {

	// A unique name for the S3 bucket.
	S3Bucket *string

	// The full S3 path (excluding bucket) to the .zip file. This file contains the
	// code that is loaded onto the cluster when it's started.
	S3Key *string

	// The version of an S3 object.
	S3ObjectVersion *string

	noSmithyDocumentSerde
}

// A list of DNS server name and server IP. This is used to set up Route-53
// outbound resolvers.
type CustomDNSServer struct {

	// The IP address of the DNS server.
	//
	// This member is required.
	CustomDNSServerIP *string

	// The name of the DNS server.
	//
	// This member is required.
	CustomDNSServerName *string

	noSmithyDocumentSerde
}

// Represents an FinSpace environment.
type Environment struct {

	// The ID of the AWS account in which the FinSpace environment is created.
	AwsAccountId *string

	// The AWS account ID of the dedicated service account associated with your
	// FinSpace environment.
	DedicatedServiceAccountId *string

	// The description of the FinSpace environment.
	Description *string

	// The Amazon Resource Name (ARN) of your FinSpace environment.
	EnvironmentArn *string

	// The identifier of the FinSpace environment.
	EnvironmentId *string

	// The sign-in URL for the web application of your FinSpace environment.
	EnvironmentUrl *string

	// The authentication mode for the environment.
	FederationMode FederationMode

	// Configuration information when authentication mode is FEDERATED.
	FederationParameters *FederationParameters

	// The KMS key id used to encrypt in the FinSpace environment.
	KmsKeyId *string

	// The name of the FinSpace environment.
	Name *string

	// The URL of the integrated FinSpace notebook environment in your web application.
	SageMakerStudioDomainUrl *string

	// The current status of creation of the FinSpace environment.
	Status EnvironmentStatus

	noSmithyDocumentSerde
}

// Provides details in the event of a failed flow, including the error type and
// the related error message.
type ErrorInfo struct {

	// Specifies the error message that appears if a flow fails.
	ErrorMessage *string

	// Specifies the type of error.
	ErrorType ErrorDetails

	noSmithyDocumentSerde
}

// Configuration information when authentication mode is FEDERATED.
type FederationParameters struct {

	// The redirect or sign-in URL that should be entered into the SAML 2.0 compliant
	// identity provider configuration (IdP).
	ApplicationCallBackURL *string

	// SAML attribute name and value. The name must always be Email and the value
	// should be set to the attribute definition in which user email is set. For
	// example, name would be Email and value
	// http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress . Please
	// check your SAML 2.0 compliant identity provider (IdP) documentation for details.
	AttributeMap map[string]string

	// Name of the identity provider (IdP).
	FederationProviderName *string

	// The Uniform Resource Name (URN). Also referred as Service Provider URN or
	// Audience URI or Service Provider Entity ID.
	FederationURN *string

	// SAML 2.0 Metadata document from identity provider (IdP).
	SamlMetadataDocument *string

	// Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
	SamlMetadataURL *string

	noSmithyDocumentSerde
}

// Defines the ICMP protocol that consists of the ICMP type and code.
type IcmpTypeCode struct {

	//  The ICMP code. A value of -1 means all codes for the specified ICMP type.
	//
	// This member is required.
	Code int32

	// The ICMP type. A value of -1 means all types.
	//
	// This member is required.
	Type int32

	noSmithyDocumentSerde
}

// The structure containing the metadata of the attached clusters.
type KxAttachedCluster struct {

	// A unique name for the attached cluster.
	ClusterName *string

	// The status of the attached cluster.
	//
	//   - PENDING – The cluster is pending creation.
	//
	//   - CREATING – The cluster creation process is in progress.
	//
	//   - CREATE_FAILED – The cluster creation process has failed.
	//
	//   - RUNNING – The cluster creation process is running.
	//
	//   - UPDATING – The cluster is in the process of being updated.
	//
	//   - DELETING – The cluster is in the process of being deleted.
	//
	//   - DELETED – The cluster has been deleted.
	//
	//   - DELETE_FAILED – The cluster failed to delete.
	ClusterStatus KxClusterStatus

	// Specifies the type of cluster. The volume for TP and RDB cluster types will be
	// used for TP logs.
	ClusterType KxClusterType

	noSmithyDocumentSerde
}

// The configuration for read only disk cache associated with a cluster.
type KxCacheStorageConfiguration struct {

	// The size of cache in Gigabytes.
	//
	// This member is required.
	Size *int32

	// The type of cache storage. The valid values are:
	//
	//   - CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
	//
	//   - CACHE_250 – This type provides at least 250 MB/s disk access throughput.
	//
	//   - CACHE_12 – This type provides at least 12 MB/s disk access throughput.
	//
	// For cache type CACHE_1000 and CACHE_250 you can select cache size as 1200 GB or
	// increments of 2400 GB. For cache type CACHE_12 you can select the cache size in
	// increments of 6000 GB.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Details of changeset.
type KxChangesetListEntry struct {

	// Beginning time from which the changeset is active. The value is determined as
	// epoch time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	ActiveFromTimestamp *time.Time

	// A unique identifier for the changeset.
	ChangesetId *string

	// The timestamp at which the changeset was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time

	// The timestamp at which the changeset was modified. The value is determined as
	// epoch time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time

	//  Status of the changeset.
	//
	//   - Pending – Changeset creation is pending.
	//
	//   - Processing – Changeset creation is running.
	//
	//   - Failed – Changeset creation has failed.
	//
	//   - Complete – Changeset creation has succeeded.
	Status ChangesetStatus

	noSmithyDocumentSerde
}

// The details of a kdb cluster.
type KxCluster struct {

	//  The availability zone identifiers for the requested regions.
	AvailabilityZoneId *string

	// The number of availability zones assigned per cluster. This can be one of the
	// following:
	//
	//   - SINGLE – Assigns one availability zone per cluster.
	//
	//   - MULTI – Assigns all the availability zones per cluster.
	AzMode KxAzMode

	// A description of the cluster.
	ClusterDescription *string

	// A unique name for the cluster.
	ClusterName *string

	// Specifies the type of KDB database that is being created. The following types
	// are available:
	//
	//   - HDB – A Historical Database. The data is only accessible with read-only
	//   permissions from one of the FinSpace managed kdb databases mounted to the
	//   cluster.
	//
	//   - RDB – A Realtime Database. This type of database captures all the data from
	//   a ticker plant and stores it in memory until the end of day, after which it
	//   writes all of its data to a disk and reloads the HDB. This cluster type requires
	//   local storage for temporary storage of data during the savedown process. If you
	//   specify this field in your request, you must provide the
	//   savedownStorageConfiguration parameter.
	//
	//   - GATEWAY – A gateway cluster allows you to access data across processes in
	//   kdb systems. It allows you to create your own routing logic using the
	//   initialization scripts and custom code. This type of cluster does not require a
	//   writable local storage.
	//
	//   - GP – A general purpose cluster allows you to quickly iterate on code during
	//   development by granting greater access to system commands and enabling a fast
	//   reload of custom code. This cluster type can optionally mount databases
	//   including cache and savedown storage. For this cluster type, the node count is
	//   fixed at 1. It does not support autoscaling and supports only SINGLE AZ mode.
	//
	//   - Tickerplant – A tickerplant cluster allows you to subscribe to feed
	//   handlers based on IAM permissions. It can publish to RDBs, other Tickerplants,
	//   and real-time subscribers (RTS). Tickerplants can persist messages to log, which
	//   is readable by any RDB environment. It supports only single-node that is only
	//   one kdb process.
	ClusterType KxClusterType

	// The timestamp at which the cluster was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time

	//  An IAM role that defines a set of permissions associated with a cluster. These
	// permissions are assumed when a cluster attempts to access another cluster.
	ExecutionRole *string

	// Specifies a Q program that will be run at launch of a cluster. It is a relative
	// path within .zip file that contains the custom code, which will be loaded on the
	// cluster. It must include the file name itself. For example, somedir/init.q .
	InitializationScript *string

	// The last time that the cluster was modified. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time

	// A version of the FinSpace managed kdb to run.
	ReleaseLabel *string

	// The status of a cluster.
	//
	//   - PENDING – The cluster is pending creation.
	//
	//   - CREATING –The cluster creation process is in progress.
	//
	//   - CREATE_FAILED– The cluster creation process has failed.
	//
	//   - RUNNING – The cluster creation process is running.
	//
	//   - UPDATING – The cluster is in the process of being updated.
	//
	//   - DELETING – The cluster is in the process of being deleted.
	//
	//   - DELETED – The cluster has been deleted.
	//
	//   - DELETE_FAILED – The cluster failed to delete.
	Status KxClusterStatus

	// The error message when a failed state occurs.
	StatusReason *string

	//  A list of volumes attached to the cluster.
	Volumes []Volume

	noSmithyDocumentSerde
}

//	The configuration that allows you to choose how you want to update code on a
//
// cluster. Depending on the option you choose, you can reduce the time it takes to
// update the cluster.
type KxClusterCodeDeploymentConfiguration struct {

	//  The type of deployment that you want on a cluster.
	//
	//   - ROLLING – This options updates the cluster by stopping the exiting q
	//   process and starting a new q process with updated configuration.
	//
	//   - NO_RESTART – This option updates the cluster without stopping the running q
	//   process. It is only available for GP type cluster. This option is quicker as
	//   it reduces the turn around time to update configuration on a cluster.
	//
	// With this deployment mode, you cannot update the initializationScript and
	//   commandLineArguments parameters.
	//
	//   - FORCE – This option updates the cluster by immediately stopping all the
	//   running processes before starting up new ones with the updated configuration.
	//
	// This member is required.
	DeploymentStrategy KxClusterCodeDeploymentStrategy

	noSmithyDocumentSerde
}

// Defines the key-value pairs to make them available inside the cluster.
type KxCommandLineArgument struct {

	// The name of the key.
	Key *string

	// The value of the key.
	Value *string

	noSmithyDocumentSerde
}

// The structure of database cache configuration that is used for mapping database
// paths to cache types in clusters.
type KxDatabaseCacheConfiguration struct {

	// The type of disk cache. This parameter is used to map the database path to
	// cache storage. The valid values are:
	//
	//   - CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
	//
	// This member is required.
	CacheType *string

	// Specifies the portions of database that will be loaded into the cache for
	// access.
	//
	// This member is required.
	DbPaths []string

	//  The name of the dataview to be used for caching historical data on disk.
	DataviewName *string

	noSmithyDocumentSerde
}

// The configuration of data that is available for querying from this database.
type KxDatabaseConfiguration struct {

	// The name of the kdb database. When this parameter is specified in the
	// structure, S3 with the whole database is included by default.
	//
	// This member is required.
	DatabaseName *string

	// Configuration details for the disk cache used to increase performance reading
	// from a kdb database mounted to the cluster.
	CacheConfigurations []KxDatabaseCacheConfiguration

	// A unique identifier of the changeset that is associated with the cluster.
	ChangesetId *string

	//  The configuration of the dataview to be used with specified cluster.
	DataviewConfiguration *KxDataviewConfiguration

	//  The name of the dataview to be used for caching historical data on disk.
	DataviewName *string

	noSmithyDocumentSerde
}

// Details about a FinSpace managed kdb database
type KxDatabaseListEntry struct {

	// The timestamp at which the database was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time

	// The name of the kdb database.
	DatabaseName *string

	// The last time that the database was modified. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The active version of the dataview that is currently in use by this cluster.
type KxDataviewActiveVersion struct {

	//  The list of clusters that are currently using this dataview.
	AttachedClusters []string

	// A unique identifier for the changeset.
	ChangesetId *string

	//  The timestamp at which the dataview version was active. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time

	//  The configuration that contains the database path of the data that you want to
	// place on each selected volume. Each segment must have a unique database path for
	// each volume. If you do not explicitly specify any database path for a volume,
	// they are accessible from the cluster through the default S3/object store
	// segment.
	SegmentConfigurations []KxDataviewSegmentConfiguration

	//  A unique identifier of the active version.
	VersionId *string

	noSmithyDocumentSerde
}

// The structure that stores the configuration details of a dataview.
type KxDataviewConfiguration struct {

	// A unique identifier for the changeset.
	ChangesetId *string

	//  The unique identifier of the dataview.
	DataviewName *string

	//  The version of the dataview corresponding to a given changeset.
	DataviewVersionId *string

	//  The db path and volume configuration for the segmented database.
	SegmentConfigurations []KxDataviewSegmentConfiguration

	noSmithyDocumentSerde
}

// A collection of kdb dataview entries.
type KxDataviewListEntry struct {

	//  The active changeset versions for the given dataview entry.
	ActiveVersions []KxDataviewActiveVersion

	//  The option to specify whether you want to apply all the future additions and
	// corrections automatically to the dataview when you ingest new changesets. The
	// default value is false.
	AutoUpdate bool

	//  The identifier of the availability zones.
	AvailabilityZoneId *string

	// The number of availability zones you want to assign per volume. Currently,
	// FinSpace only supports SINGLE for volumes. This places dataview in a single AZ.
	AzMode KxAzMode

	// A unique identifier for the changeset.
	ChangesetId *string

	//  The timestamp at which the dataview list entry was created in FinSpace. The
	// value is determined as epoch time in milliseconds. For example, the value for
	// Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time

	//  A unique identifier of the database.
	DatabaseName *string

	//  A unique identifier of the dataview.
	DataviewName *string

	//  A description for the dataview list entry.
	Description *string

	// A unique identifier for the kdb environment.
	EnvironmentId *string

	// The last time that the dataview list was updated in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time

	//  Returns True if the dataview is created as writeable and False otherwise.
	ReadWrite bool

	//  The configuration that contains the database path of the data that you want to
	// place on each selected volume. Each segment must have a unique database path for
	// each volume. If you do not explicitly specify any database path for a volume,
	// they are accessible from the cluster through the default S3/object store
	// segment.
	SegmentConfigurations []KxDataviewSegmentConfiguration

	//  The status of a given dataview entry.
	Status KxDataviewStatus

	//  The error message when a failed state occurs.
	StatusReason *string

	noSmithyDocumentSerde
}

//	The configuration that contains the database path of the data that you want to
//
// place on each selected volume. Each segment must have a unique database path for
// each volume. If you do not explicitly specify any database path for a volume,
// they are accessible from the cluster through the default S3/object store
// segment.
type KxDataviewSegmentConfiguration struct {

	//  The database path of the data that you want to place on each selected volume
	// for the segment. Each segment must have a unique database path for each volume.
	//
	// This member is required.
	DbPaths []string

	//  The name of the volume where you want to add data.
	//
	// This member is required.
	VolumeName *string

	// Enables on-demand caching on the selected database path when a particular file
	// or a column of the database is accessed. When on demand caching is True,
	// dataviews perform minimal loading of files on the filesystem as needed. When it
	// is set to False, everything is cached. The default value is False.
	OnDemand bool

	noSmithyDocumentSerde
}

//	The configuration that allows you to choose how you want to update the
//
// databases on a cluster. Depending on the option you choose, you can reduce the
// time it takes to update the cluster.
type KxDeploymentConfiguration struct {

	//  The type of deployment that you want on a cluster.
	//
	//   - ROLLING – This options updates the cluster by stopping the exiting q
	//   process and starting a new q process with updated configuration.
	//
	//   - NO_RESTART – This option updates the cluster without stopping the running q
	//   process. It is only available for HDB type cluster. This option is quicker as
	//   it reduces the turn around time to update configuration on a cluster.
	//
	// With this deployment mode, you cannot update the initializationScript and
	//   commandLineArguments parameters.
	//
	// This member is required.
	DeploymentStrategy KxDeploymentStrategy

	noSmithyDocumentSerde
}

// The details of a kdb environment.
type KxEnvironment struct {

	// The identifier of the availability zones where subnets for the environment are
	// created.
	AvailabilityZoneIds []string

	// The unique identifier of the AWS account in which you create the kdb
	// environment.
	AwsAccountId *string

	// The Amazon Resource Name (ARN) of the certificate authority:
	CertificateAuthorityArn *string

	// The timestamp at which the kdb environment was created in FinSpace. The value
	// is determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreationTimestamp *time.Time

	// A list of DNS server name and server IP. This is used to set up Route-53
	// outbound resolvers.
	CustomDNSConfiguration []CustomDNSServer

	// A unique identifier for the AWS environment infrastructure account.
	DedicatedServiceAccountId *string

	// A description of the kdb environment.
	Description *string

	// The status of DNS configuration.
	DnsStatus DnsStatus

	// The Amazon Resource Name (ARN) of your kdb environment.
	EnvironmentArn *string

	// A unique identifier for the kdb environment.
	EnvironmentId *string

	// Specifies the error message that appears if a flow fails.
	ErrorMessage *string

	// The unique identifier of the KMS key.
	KmsKeyId *string

	// The name of the kdb environment.
	Name *string

	// The status of the environment creation.
	//
	//   - CREATE_REQUESTED – Environment creation has been requested.
	//
	//   - CREATING – Environment is in the process of being created.
	//
	//   - FAILED_CREATION – Environment creation has failed.
	//
	//   - CREATED – Environment is successfully created and is currently active.
	//
	//   - DELETE REQUESTED – Environment deletion has been requested.
	//
	//   - DELETING – Environment is in the process of being deleted.
	//
	//   - RETRY_DELETION – Initial environment deletion failed, system is
	//   reattempting delete.
	//
	//   - DELETED – Environment has been deleted.
	//
	//   - FAILED_DELETION – Environment deletion has failed.
	Status EnvironmentStatus

	// The status of the network configuration.
	TgwStatus TgwStatus

	// Specifies the transit gateway and network configuration to connect the kdb
	// environment to an internal network.
	TransitGatewayConfiguration *TransitGatewayConfiguration

	// The timestamp at which the kdb environment was modified in FinSpace. The value
	// is determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	UpdateTimestamp *time.Time

	noSmithyDocumentSerde
}

//	The structure containing the size and type of the network attached storage
//
// (NAS_1) file system volume.
type KxNAS1Configuration struct {

	//  The size of the network attached storage. For storage type SSD_1000 and SSD_250
	// you can select the minimum size as 1200 GB or increments of 2400 GB. For storage
	// type HDD_12 you can select the minimum size as 6000 GB or increments of 6000 GB.
	Size *int32

	//  The type of the network attached storage.
	Type KxNAS1Type

	noSmithyDocumentSerde
}

// A structure that stores metadata for a kdb node.
type KxNode struct {

	// The identifier of the availability zones where subnets for the environment are
	// created.
	AvailabilityZoneId *string

	// The time when a particular node is started. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LaunchTime *time.Time

	// A unique identifier for the node.
	NodeId *string

	//  Specifies the status of the cluster nodes.
	//
	//   - RUNNING – The node is actively serving.
	//
	//   - PROVISIONING – The node is being prepared.
	Status KxNodeStatus

	noSmithyDocumentSerde
}

// The size and type of temporary storage that is used to hold data during the
// savedown process. All the data written to this storage space is lost when the
// cluster node is restarted.
type KxSavedownStorageConfiguration struct {

	// The size of temporary storage in gibibytes.
	Size *int32

	// The type of writeable storage space for temporarily storing your savedown data.
	// The valid values are:
	//
	//   - SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
	Type KxSavedownStorageType

	//  The name of the kdb volume that you want to use as writeable save-down storage
	// for clusters.
	VolumeName *string

	noSmithyDocumentSerde
}

// A structure for storing metadata of scaling group.
type KxScalingGroup struct {

	// The identifier of the availability zones.
	AvailabilityZoneId *string

	//  The list of clusters currently active in a given scaling group.
	Clusters []string

	//  The timestamp at which the scaling group was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time

	//  The memory and CPU capabilities of the scaling group host on which FinSpace
	// Managed kdb clusters will be placed.
	//
	// You can add one of the following values:
	//
	//   - kx.sg.4xlarge – The host type with a configuration of 108 GiB memory and 16
	//   vCPUs.
	//
	//   - kx.sg.8xlarge – The host type with a configuration of 216 GiB memory and 32
	//   vCPUs.
	//
	//   - kx.sg.16xlarge – The host type with a configuration of 432 GiB memory and 64
	//   vCPUs.
	//
	//   - kx.sg.32xlarge – The host type with a configuration of 864 GiB memory and
	//   128 vCPUs.
	//
	//   - kx.sg1.16xlarge – The host type with a configuration of 1949 GiB memory and
	//   64 vCPUs.
	//
	//   - kx.sg1.24xlarge – The host type with a configuration of 2948 GiB memory and
	//   96 vCPUs.
	HostType *string

	//  The last time that the scaling group was updated in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time

	// A unique identifier for the kdb scaling group.
	ScalingGroupName *string

	//  The status of scaling groups.
	Status KxScalingGroupStatus

	//  The error message when a failed state occurs.
	StatusReason *string

	noSmithyDocumentSerde
}

// The structure that stores the capacity configuration details of a scaling group.
type KxScalingGroupConfiguration struct {

	//  A reservation of the minimum amount of memory that should be available on the
	// scaling group for a kdb cluster to be successfully placed in a scaling group.
	//
	// This member is required.
	MemoryReservation *int32

	//  The number of kdb cluster nodes.
	//
	// This member is required.
	NodeCount *int32

	// A unique identifier for the kdb scaling group.
	//
	// This member is required.
	ScalingGroupName *string

	//  The number of vCPUs that you want to reserve for each node of this kdb cluster
	// on the scaling group host.
	Cpu *float64

	//  An optional hard limit on the amount of memory a kdb cluster can use.
	MemoryLimit *int32

	noSmithyDocumentSerde
}

// A structure that stores metadata for a kdb user.
type KxUser struct {

	// The timestamp at which the kdb user was created.
	CreateTimestamp *time.Time

	// The IAM role ARN that is associated with the user.
	IamRole *string

	// The timestamp at which the kdb user was updated.
	UpdateTimestamp *time.Time

	//  The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see [IAM Identifiers]in the IAM User Guide.
	//
	// [IAM Identifiers]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html
	UserArn *string

	// A unique identifier for the user.
	UserName *string

	noSmithyDocumentSerde
}

// The structure that contains the metadata of the volume.
type KxVolume struct {

	// The identifier of the availability zones.
	AvailabilityZoneIds []string

	// The number of availability zones you want to assign per volume. Currently,
	// FinSpace only supports SINGLE for volumes. This places dataview in a single AZ.
	AzMode KxAzMode

	//  The timestamp at which the volume was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time

	//  A description of the volume.
	Description *string

	// The last time that the volume was updated in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November 1,
	// 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time

	// The status of volume.
	//
	//   - CREATING – The volume creation is in progress.
	//
	//   - CREATE_FAILED – The volume creation has failed.
	//
	//   - ACTIVE – The volume is active.
	//
	//   - UPDATING – The volume is in the process of being updated.
	//
	//   - UPDATE_FAILED – The update action failed.
	//
	//   - UPDATED – The volume is successfully updated.
	//
	//   - DELETING – The volume is in the process of being deleted.
	//
	//   - DELETE_FAILED – The system failed to delete the volume.
	//
	//   - DELETED – The volume is successfully deleted.
	Status KxVolumeStatus

	// The error message when a failed state occurs.
	StatusReason *string

	// A unique identifier for the volume.
	VolumeName *string

	//  The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type.
	VolumeType KxVolumeType

	noSmithyDocumentSerde
}

//	The network access control list (ACL) is an optional layer of security for
//
// your VPC that acts as a firewall for controlling traffic in and out of one or
// more subnets. The entry is a set of numbered ingress and egress rules that
// determine whether a packet should be allowed in or out of a subnet associated
// with the ACL. We process the entries in the ACL according to the rule numbers,
// in ascending order.
type NetworkACLEntry struct {

	//  The IPv4 network range to allow or deny, in CIDR notation. For example,
	// 172.16.0.0/24 . We modify the specified CIDR block to its canonical form. For
	// example, if you specify 100.68.0.18/18 , we modify it to 100.68.0.0/18 .
	//
	// This member is required.
	CidrBlock *string

	//  The protocol number. A value of -1 means all the protocols.
	//
	// This member is required.
	Protocol *string

	//  Indicates whether to allow or deny the traffic that matches the rule.
	//
	// This member is required.
	RuleAction RuleAction

	//  The rule number for the entry. For example 100. All the network ACL entries
	// are processed in ascending order by rule number.
	//
	// This member is required.
	RuleNumber *int32

	//  Defines the ICMP protocol that consists of the ICMP type and code.
	IcmpTypeCode *IcmpTypeCode

	//  The range of ports the rule applies to.
	PortRange *PortRange

	noSmithyDocumentSerde
}

// The range of ports the rule applies to.
type PortRange struct {

	//  The first port in the range.
	//
	// This member is required.
	From int32

	//  The last port in the range.
	//
	// This member is required.
	To int32

	noSmithyDocumentSerde
}

// Configuration information for the superuser.
type SuperuserParameters struct {

	// The email address of the superuser.
	//
	// This member is required.
	EmailAddress *string

	// The first name of the superuser.
	//
	// This member is required.
	FirstName *string

	// The last name of the superuser.
	//
	// This member is required.
	LastName *string

	noSmithyDocumentSerde
}

//	A configuration to store the Tickerplant logs. It consists of a list of
//
// volumes that will be mounted to your cluster. For the cluster type Tickerplant ,
// the location of the TP volume on the cluster will be available by using the
// global variable .aws.tp_log_path .
type TickerplantLogConfiguration struct {

	//  The name of the volumes for tickerplant logs.
	TickerplantLogVolumes []string

	noSmithyDocumentSerde
}

// The structure of the transit gateway and network configuration that is used to
// connect the kdb environment to an internal network.
type TransitGatewayConfiguration struct {

	// The routing CIDR on behalf of kdb environment. It could be any "/26 range in
	// the 100.64.0.0 CIDR space. After providing, it will be added to the customer's
	// transit gateway routing table so that the traffics could be routed to kdb
	// network.
	//
	// This member is required.
	RoutableCIDRSpace *string

	// The identifier of the transit gateway created by the customer to connect
	// outbound traffics from kdb network to your internal network.
	//
	// This member is required.
	TransitGatewayID *string

	//  The rules that define how you manage the outbound traffic from kdb network to
	// your internal network.
	AttachmentNetworkAclConfiguration []NetworkACLEntry

	noSmithyDocumentSerde
}

// The structure that consists of name and type of volume.
type Volume struct {

	// A unique identifier for the volume.
	VolumeName *string

	//  The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type.
	VolumeType VolumeType

	noSmithyDocumentSerde
}

// Configuration details about the network where the Privatelink endpoint of the
// cluster resides.
type VpcConfiguration struct {

	// The IP address type for cluster network configuration parameters. The following
	// type is available:
	//
	//   - IP_V4 – IP address version 4
	IpAddressType IPAddressType

	// The unique identifier of the VPC security group applied to the VPC endpoint ENI
	// for the cluster.
	SecurityGroupIds []string

	// The identifier of the subnet that the Privatelink VPC endpoint uses to connect
	// to the cluster.
	SubnetIds []string

	// The identifier of the VPC endpoint.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
