package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// DatabasesClient is the the Azure SQL Database management API provides a
// RESTful set of web services that interact with Azure SQL Database services
// to manage your databases. The API enables you to create, retrieve, update,
// and delete databases.
type DatabasesClient struct {
	ManagementClient
}

// NewDatabasesClient creates an instance of the DatabasesClient client.
func NewDatabasesClient(subscriptionID string) DatabasesClient {
	return NewDatabasesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDatabasesClientWithBaseURI creates an instance of the DatabasesClient
// client.
func NewDatabasesClientWithBaseURI(baseURI string, subscriptionID string) DatabasesClient {
	return DatabasesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateImportOperation creates an import operation that imports a bacpac into
// an existing database. The existing database must be empty. This method may
// poll for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database to import into parameters is the required parameters for
// importing a Bacpac into a database.
func (client DatabasesClient) CreateImportOperation(resourceGroupName string, serverName string, databaseName string, parameters ImportExtensionRequest, cancel <-chan struct{}) (<-chan ImportExportResponse, <-chan error) {
	resultChan := make(chan ImportExportResponse, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ImportExtensionProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ImportExtensionProperties.OperationMode", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "sql.DatabasesClient", "CreateImportOperation")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result ImportExportResponse
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateImportOperationPreparer(resourceGroupName, serverName, databaseName, parameters, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateImportOperation", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateImportOperationSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateImportOperation", resp, "Failure sending request")
			return
		}

		result, err = client.CreateImportOperationResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateImportOperation", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateImportOperationPreparer prepares the CreateImportOperation request.
func (client DatabasesClient) CreateImportOperationPreparer(resourceGroupName string, serverName string, databaseName string, parameters ImportExtensionRequest, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/extensions/import", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateImportOperationSender sends the CreateImportOperation request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) CreateImportOperationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateImportOperationResponder handles the response to the CreateImportOperation request. The method always
// closes the http.Response Body.
func (client DatabasesClient) CreateImportOperationResponder(resp *http.Response) (result ImportExportResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate creates a new database or updates an existing database.
// Location is a required property in the request body, and it must be the same
// as the location of the SQL server. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database to be operated on (updated or created). parameters is the
// required parameters for creating or updating a database.
func (client DatabasesClient) CreateOrUpdate(resourceGroupName string, serverName string, databaseName string, parameters Database, cancel <-chan struct{}) (<-chan Database, <-chan error) {
	resultChan := make(chan Database, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result Database
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdatePreparer(resourceGroupName, serverName, databaseName, parameters, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdate", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdate", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client DatabasesClient) CreateOrUpdatePreparer(resourceGroupName string, serverName string, databaseName string, parameters Database, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client DatabasesClient) CreateOrUpdateResponder(resp *http.Response) (result Database, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateBlobAuditingPolicy creates or updates a database's blob
// auditing policy.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database for which database blob audit policy will be defined.
// parameters is the database blob auditing policy.
func (client DatabasesClient) CreateOrUpdateBlobAuditingPolicy(resourceGroupName string, serverName string, databaseName string, parameters DatabaseBlobAuditingPolicy) (result DatabaseBlobAuditingPolicy, err error) {
	req, err := client.CreateOrUpdateBlobAuditingPolicyPreparer(resourceGroupName, serverName, databaseName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateBlobAuditingPolicy", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateBlobAuditingPolicySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateBlobAuditingPolicy", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateBlobAuditingPolicyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateBlobAuditingPolicy", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateBlobAuditingPolicyPreparer prepares the CreateOrUpdateBlobAuditingPolicy request.
func (client DatabasesClient) CreateOrUpdateBlobAuditingPolicyPreparer(resourceGroupName string, serverName string, databaseName string, parameters DatabaseBlobAuditingPolicy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-05-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/auditingSettings/default", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateBlobAuditingPolicySender sends the CreateOrUpdateBlobAuditingPolicy request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) CreateOrUpdateBlobAuditingPolicySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateBlobAuditingPolicyResponder handles the response to the CreateOrUpdateBlobAuditingPolicy request. The method always
// closes the http.Response Body.
func (client DatabasesClient) CreateOrUpdateBlobAuditingPolicyResponder(resp *http.Response) (result DatabaseBlobAuditingPolicy, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateThreatDetectionPolicy creates or updates a database's threat
// detection policy.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database for which database Threat Detection policy is defined.
// parameters is the database Threat Detection policy.
func (client DatabasesClient) CreateOrUpdateThreatDetectionPolicy(resourceGroupName string, serverName string, databaseName string, parameters DatabaseSecurityAlertPolicy) (result DatabaseSecurityAlertPolicy, err error) {
	req, err := client.CreateOrUpdateThreatDetectionPolicyPreparer(resourceGroupName, serverName, databaseName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateThreatDetectionPolicy", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateThreatDetectionPolicySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateThreatDetectionPolicy", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateThreatDetectionPolicyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateThreatDetectionPolicy", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateThreatDetectionPolicyPreparer prepares the CreateOrUpdateThreatDetectionPolicy request.
func (client DatabasesClient) CreateOrUpdateThreatDetectionPolicyPreparer(resourceGroupName string, serverName string, databaseName string, parameters DatabaseSecurityAlertPolicy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/default", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateThreatDetectionPolicySender sends the CreateOrUpdateThreatDetectionPolicy request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) CreateOrUpdateThreatDetectionPolicySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateThreatDetectionPolicyResponder handles the response to the CreateOrUpdateThreatDetectionPolicy request. The method always
// closes the http.Response Body.
func (client DatabasesClient) CreateOrUpdateThreatDetectionPolicyResponder(resp *http.Response) (result DatabaseSecurityAlertPolicy, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateTransparentDataEncryptionConfiguration creates or updates a
// database's transparent data encryption configuration.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database for which setting the transparent data encryption applies.
// parameters is the required parameters for creating or updating transparent
// data encryption.
func (client DatabasesClient) CreateOrUpdateTransparentDataEncryptionConfiguration(resourceGroupName string, serverName string, databaseName string, parameters TransparentDataEncryption) (result TransparentDataEncryption, err error) {
	req, err := client.CreateOrUpdateTransparentDataEncryptionConfigurationPreparer(resourceGroupName, serverName, databaseName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateTransparentDataEncryptionConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateTransparentDataEncryptionConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateTransparentDataEncryptionConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateTransparentDataEncryptionConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "CreateOrUpdateTransparentDataEncryptionConfiguration", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateTransparentDataEncryptionConfigurationPreparer prepares the CreateOrUpdateTransparentDataEncryptionConfiguration request.
func (client DatabasesClient) CreateOrUpdateTransparentDataEncryptionConfigurationPreparer(resourceGroupName string, serverName string, databaseName string, parameters TransparentDataEncryption) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/current", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateTransparentDataEncryptionConfigurationSender sends the CreateOrUpdateTransparentDataEncryptionConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) CreateOrUpdateTransparentDataEncryptionConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateTransparentDataEncryptionConfigurationResponder handles the response to the CreateOrUpdateTransparentDataEncryptionConfiguration request. The method always
// closes the http.Response Body.
func (client DatabasesClient) CreateOrUpdateTransparentDataEncryptionConfigurationResponder(resp *http.Response) (result TransparentDataEncryption, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a database.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database to be deleted.
func (client DatabasesClient) Delete(resourceGroupName string, serverName string, databaseName string) (result autorest.Response, err error) {
	req, err := client.DeletePreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client DatabasesClient) DeletePreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client DatabasesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteReplicationLink deletes a database replication link. Cannot be done
// during failover.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database that has the replication link to be dropped. linkID is the
// ID of the replication link to be deleted.
func (client DatabasesClient) DeleteReplicationLink(resourceGroupName string, serverName string, databaseName string, linkID string) (result autorest.Response, err error) {
	req, err := client.DeleteReplicationLinkPreparer(resourceGroupName, serverName, databaseName, linkID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "DeleteReplicationLink", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteReplicationLinkSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "DeleteReplicationLink", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteReplicationLinkResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "DeleteReplicationLink", resp, "Failure responding to request")
	}

	return
}

// DeleteReplicationLinkPreparer prepares the DeleteReplicationLink request.
func (client DatabasesClient) DeleteReplicationLinkPreparer(resourceGroupName string, serverName string, databaseName string, linkID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"linkId":            autorest.Encode("path", linkID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteReplicationLinkSender sends the DeleteReplicationLink request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) DeleteReplicationLinkSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteReplicationLinkResponder handles the response to the DeleteReplicationLink request. The method always
// closes the http.Response Body.
func (client DatabasesClient) DeleteReplicationLinkResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Export exports a database to a bacpac. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database to be exported. parameters is the required parameters for
// exporting a database.
func (client DatabasesClient) Export(resourceGroupName string, serverName string, databaseName string, parameters ExportRequest, cancel <-chan struct{}) (<-chan ImportExportResponse, <-chan error) {
	resultChan := make(chan ImportExportResponse, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.StorageKey", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.StorageURI", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.AdministratorLogin", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.AdministratorLoginPassword", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "sql.DatabasesClient", "Export")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result ImportExportResponse
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.ExportPreparer(resourceGroupName, serverName, databaseName, parameters, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Export", nil, "Failure preparing request")
			return
		}

		resp, err := client.ExportSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Export", resp, "Failure sending request")
			return
		}

		result, err = client.ExportResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Export", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// ExportPreparer prepares the Export request.
func (client DatabasesClient) ExportPreparer(resourceGroupName string, serverName string, databaseName string, parameters ExportRequest, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/export", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ExportSender sends the Export request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ExportSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ExportResponder handles the response to the Export request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ExportResponder(resp *http.Response) (result ImportExportResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// FailoverReplicationLink sets which replica database is primary by failing
// over from the current primary replica database. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database that has the replication link to be failed over. linkID is
// the ID of the replication link to be failed over.
func (client DatabasesClient) FailoverReplicationLink(resourceGroupName string, serverName string, databaseName string, linkID string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result autorest.Response
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.FailoverReplicationLinkPreparer(resourceGroupName, serverName, databaseName, linkID, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "FailoverReplicationLink", nil, "Failure preparing request")
			return
		}

		resp, err := client.FailoverReplicationLinkSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "FailoverReplicationLink", resp, "Failure sending request")
			return
		}

		result, err = client.FailoverReplicationLinkResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "FailoverReplicationLink", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// FailoverReplicationLinkPreparer prepares the FailoverReplicationLink request.
func (client DatabasesClient) FailoverReplicationLinkPreparer(resourceGroupName string, serverName string, databaseName string, linkID string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"linkId":            autorest.Encode("path", linkID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}/failover", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// FailoverReplicationLinkSender sends the FailoverReplicationLink request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) FailoverReplicationLinkSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// FailoverReplicationLinkResponder handles the response to the FailoverReplicationLink request. The method always
// closes the http.Response Body.
func (client DatabasesClient) FailoverReplicationLinkResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// FailoverReplicationLinkAllowDataLoss sets which replica database is primary
// by failing over from the current primary replica database. This operation
// might result in data loss. This method may poll for completion. Polling can
// be canceled by passing the cancel channel argument. The channel will be used
// to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database that has the replication link to be failed over. linkID is
// the ID of the replication link to be failed over.
func (client DatabasesClient) FailoverReplicationLinkAllowDataLoss(resourceGroupName string, serverName string, databaseName string, linkID string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result autorest.Response
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.FailoverReplicationLinkAllowDataLossPreparer(resourceGroupName, serverName, databaseName, linkID, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "FailoverReplicationLinkAllowDataLoss", nil, "Failure preparing request")
			return
		}

		resp, err := client.FailoverReplicationLinkAllowDataLossSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "FailoverReplicationLinkAllowDataLoss", resp, "Failure sending request")
			return
		}

		result, err = client.FailoverReplicationLinkAllowDataLossResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "FailoverReplicationLinkAllowDataLoss", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// FailoverReplicationLinkAllowDataLossPreparer prepares the FailoverReplicationLinkAllowDataLoss request.
func (client DatabasesClient) FailoverReplicationLinkAllowDataLossPreparer(resourceGroupName string, serverName string, databaseName string, linkID string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"linkId":            autorest.Encode("path", linkID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}/forceFailoverAllowDataLoss", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// FailoverReplicationLinkAllowDataLossSender sends the FailoverReplicationLinkAllowDataLoss request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) FailoverReplicationLinkAllowDataLossSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// FailoverReplicationLinkAllowDataLossResponder handles the response to the FailoverReplicationLinkAllowDataLoss request. The method always
// closes the http.Response Body.
func (client DatabasesClient) FailoverReplicationLinkAllowDataLossResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a database.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database to be retrieved. expand is a comma separated list of child
// objects to expand in the response. Possible properties: serviceTierAdvisors,
// transparentDataEncryption.
func (client DatabasesClient) Get(resourceGroupName string, serverName string, databaseName string, expand string) (result Database, err error) {
	req, err := client.GetPreparer(resourceGroupName, serverName, databaseName, expand)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client DatabasesClient) GetPreparer(resourceGroupName string, serverName string, databaseName string, expand string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DatabasesClient) GetResponder(resp *http.Response) (result Database, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBlobAuditingPolicy gets a database's blob auditing policy.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database for which database blob audit policy is defined.
func (client DatabasesClient) GetBlobAuditingPolicy(resourceGroupName string, serverName string, databaseName string) (result DatabaseBlobAuditingPolicy, err error) {
	req, err := client.GetBlobAuditingPolicyPreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetBlobAuditingPolicy", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBlobAuditingPolicySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetBlobAuditingPolicy", resp, "Failure sending request")
		return
	}

	result, err = client.GetBlobAuditingPolicyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetBlobAuditingPolicy", resp, "Failure responding to request")
	}

	return
}

// GetBlobAuditingPolicyPreparer prepares the GetBlobAuditingPolicy request.
func (client DatabasesClient) GetBlobAuditingPolicyPreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-05-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/auditingSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBlobAuditingPolicySender sends the GetBlobAuditingPolicy request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) GetBlobAuditingPolicySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetBlobAuditingPolicyResponder handles the response to the GetBlobAuditingPolicy request. The method always
// closes the http.Response Body.
func (client DatabasesClient) GetBlobAuditingPolicyResponder(resp *http.Response) (result DatabaseBlobAuditingPolicy, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetReplicationLink gets a database replication link.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database to get the link for. linkID is the replication link ID to be
// retrieved.
func (client DatabasesClient) GetReplicationLink(resourceGroupName string, serverName string, databaseName string, linkID string) (result ReplicationLink, err error) {
	req, err := client.GetReplicationLinkPreparer(resourceGroupName, serverName, databaseName, linkID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetReplicationLink", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetReplicationLinkSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetReplicationLink", resp, "Failure sending request")
		return
	}

	result, err = client.GetReplicationLinkResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetReplicationLink", resp, "Failure responding to request")
	}

	return
}

// GetReplicationLinkPreparer prepares the GetReplicationLink request.
func (client DatabasesClient) GetReplicationLinkPreparer(resourceGroupName string, serverName string, databaseName string, linkID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"linkId":            autorest.Encode("path", linkID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetReplicationLinkSender sends the GetReplicationLink request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) GetReplicationLinkSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetReplicationLinkResponder handles the response to the GetReplicationLink request. The method always
// closes the http.Response Body.
func (client DatabasesClient) GetReplicationLinkResponder(resp *http.Response) (result ReplicationLink, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServiceTierAdvisor gets a service tier advisor.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of database. serviceTierAdvisorName is the name of service tier advisor.
func (client DatabasesClient) GetServiceTierAdvisor(resourceGroupName string, serverName string, databaseName string, serviceTierAdvisorName string) (result ServiceTierAdvisor, err error) {
	req, err := client.GetServiceTierAdvisorPreparer(resourceGroupName, serverName, databaseName, serviceTierAdvisorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetServiceTierAdvisor", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServiceTierAdvisorSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetServiceTierAdvisor", resp, "Failure sending request")
		return
	}

	result, err = client.GetServiceTierAdvisorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetServiceTierAdvisor", resp, "Failure responding to request")
	}

	return
}

// GetServiceTierAdvisorPreparer prepares the GetServiceTierAdvisor request.
func (client DatabasesClient) GetServiceTierAdvisorPreparer(resourceGroupName string, serverName string, databaseName string, serviceTierAdvisorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":           autorest.Encode("path", databaseName),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"serverName":             autorest.Encode("path", serverName),
		"serviceTierAdvisorName": autorest.Encode("path", serviceTierAdvisorName),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/serviceTierAdvisors/{serviceTierAdvisorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetServiceTierAdvisorSender sends the GetServiceTierAdvisor request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) GetServiceTierAdvisorSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetServiceTierAdvisorResponder handles the response to the GetServiceTierAdvisor request. The method always
// closes the http.Response Body.
func (client DatabasesClient) GetServiceTierAdvisorResponder(resp *http.Response) (result ServiceTierAdvisor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetThreatDetectionPolicy gets a database's threat detection policy.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database for which database Threat Detection policy is defined.
func (client DatabasesClient) GetThreatDetectionPolicy(resourceGroupName string, serverName string, databaseName string) (result DatabaseSecurityAlertPolicy, err error) {
	req, err := client.GetThreatDetectionPolicyPreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetThreatDetectionPolicy", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetThreatDetectionPolicySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetThreatDetectionPolicy", resp, "Failure sending request")
		return
	}

	result, err = client.GetThreatDetectionPolicyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetThreatDetectionPolicy", resp, "Failure responding to request")
	}

	return
}

// GetThreatDetectionPolicyPreparer prepares the GetThreatDetectionPolicy request.
func (client DatabasesClient) GetThreatDetectionPolicyPreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetThreatDetectionPolicySender sends the GetThreatDetectionPolicy request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) GetThreatDetectionPolicySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetThreatDetectionPolicyResponder handles the response to the GetThreatDetectionPolicy request. The method always
// closes the http.Response Body.
func (client DatabasesClient) GetThreatDetectionPolicyResponder(resp *http.Response) (result DatabaseSecurityAlertPolicy, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTransparentDataEncryptionConfiguration gets a database's transparent data
// encryption configuration.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database for which the transparent data encryption applies.
func (client DatabasesClient) GetTransparentDataEncryptionConfiguration(resourceGroupName string, serverName string, databaseName string) (result TransparentDataEncryption, err error) {
	req, err := client.GetTransparentDataEncryptionConfigurationPreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetTransparentDataEncryptionConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTransparentDataEncryptionConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetTransparentDataEncryptionConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetTransparentDataEncryptionConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "GetTransparentDataEncryptionConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetTransparentDataEncryptionConfigurationPreparer prepares the GetTransparentDataEncryptionConfiguration request.
func (client DatabasesClient) GetTransparentDataEncryptionConfigurationPreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/current", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetTransparentDataEncryptionConfigurationSender sends the GetTransparentDataEncryptionConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) GetTransparentDataEncryptionConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetTransparentDataEncryptionConfigurationResponder handles the response to the GetTransparentDataEncryptionConfiguration request. The method always
// closes the http.Response Body.
func (client DatabasesClient) GetTransparentDataEncryptionConfigurationResponder(resp *http.Response) (result TransparentDataEncryption, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Import imports a bacpac into a new database.  This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. parameters is the required
// parameters for importing a Bacpac into a database.
func (client DatabasesClient) Import(resourceGroupName string, serverName string, parameters ImportRequest, cancel <-chan struct{}) (<-chan ImportExportResponse, <-chan error) {
	resultChan := make(chan ImportExportResponse, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.DatabaseName", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.MaxSizeBytes", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "sql.DatabasesClient", "Import")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result ImportExportResponse
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.ImportPreparer(resourceGroupName, serverName, parameters, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Import", nil, "Failure preparing request")
			return
		}

		resp, err := client.ImportSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Import", resp, "Failure sending request")
			return
		}

		result, err = client.ImportResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Import", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// ImportPreparer prepares the Import request.
func (client DatabasesClient) ImportPreparer(resourceGroupName string, serverName string, parameters ImportRequest, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/import", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ImportSender sends the Import request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ImportSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ImportResponder handles the response to the Import request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ImportResponder(resp *http.Response) (result ImportExportResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByServer returns a list of databases in a server.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. expand is a comma
// separated list of child objects to expand in the response. Possible
// properties: serviceTierAdvisors, transparentDataEncryption. filter is an
// OData filter expression that describes a subset of databases to return.
func (client DatabasesClient) ListByServer(resourceGroupName string, serverName string, expand string, filter string) (result DatabaseListResult, err error) {
	req, err := client.ListByServerPreparer(resourceGroupName, serverName, expand, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListByServer", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByServerSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListByServer", resp, "Failure sending request")
		return
	}

	result, err = client.ListByServerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListByServer", resp, "Failure responding to request")
	}

	return
}

// ListByServerPreparer prepares the ListByServer request.
func (client DatabasesClient) ListByServerPreparer(resourceGroupName string, serverName string, expand string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByServerSender sends the ListByServer request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ListByServerSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByServerResponder handles the response to the ListByServer request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ListByServerResponder(resp *http.Response) (result DatabaseListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListReplicationLinks lists a database's replication links.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database to retrieve links for.
func (client DatabasesClient) ListReplicationLinks(resourceGroupName string, serverName string, databaseName string) (result ReplicationLinkListResult, err error) {
	req, err := client.ListReplicationLinksPreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListReplicationLinks", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListReplicationLinksSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListReplicationLinks", resp, "Failure sending request")
		return
	}

	result, err = client.ListReplicationLinksResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListReplicationLinks", resp, "Failure responding to request")
	}

	return
}

// ListReplicationLinksPreparer prepares the ListReplicationLinks request.
func (client DatabasesClient) ListReplicationLinksPreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListReplicationLinksSender sends the ListReplicationLinks request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ListReplicationLinksSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListReplicationLinksResponder handles the response to the ListReplicationLinks request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ListReplicationLinksResponder(resp *http.Response) (result ReplicationLinkListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRestorePoints returns a list of database restore points.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database from which to retrieve available restore points.
func (client DatabasesClient) ListRestorePoints(resourceGroupName string, serverName string, databaseName string) (result RestorePointListResult, err error) {
	req, err := client.ListRestorePointsPreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListRestorePoints", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRestorePointsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListRestorePoints", resp, "Failure sending request")
		return
	}

	result, err = client.ListRestorePointsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListRestorePoints", resp, "Failure responding to request")
	}

	return
}

// ListRestorePointsPreparer prepares the ListRestorePoints request.
func (client DatabasesClient) ListRestorePointsPreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRestorePointsSender sends the ListRestorePoints request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ListRestorePointsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListRestorePointsResponder handles the response to the ListRestorePoints request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ListRestorePointsResponder(resp *http.Response) (result RestorePointListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListServiceTierAdvisors returns service tier advisors for specified
// database.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of database.
func (client DatabasesClient) ListServiceTierAdvisors(resourceGroupName string, serverName string, databaseName string) (result ServiceTierAdvisorListResult, err error) {
	req, err := client.ListServiceTierAdvisorsPreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListServiceTierAdvisors", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListServiceTierAdvisorsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListServiceTierAdvisors", resp, "Failure sending request")
		return
	}

	result, err = client.ListServiceTierAdvisorsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListServiceTierAdvisors", resp, "Failure responding to request")
	}

	return
}

// ListServiceTierAdvisorsPreparer prepares the ListServiceTierAdvisors request.
func (client DatabasesClient) ListServiceTierAdvisorsPreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/serviceTierAdvisors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListServiceTierAdvisorsSender sends the ListServiceTierAdvisors request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ListServiceTierAdvisorsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListServiceTierAdvisorsResponder handles the response to the ListServiceTierAdvisors request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ListServiceTierAdvisorsResponder(resp *http.Response) (result ServiceTierAdvisorListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListTransparentDataEncryptionActivity returns a database's transparent data
// encryption operation result.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database for which the transparent data encryption applies.
func (client DatabasesClient) ListTransparentDataEncryptionActivity(resourceGroupName string, serverName string, databaseName string) (result TransparentDataEncryptionActivityListResult, err error) {
	req, err := client.ListTransparentDataEncryptionActivityPreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListTransparentDataEncryptionActivity", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTransparentDataEncryptionActivitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListTransparentDataEncryptionActivity", resp, "Failure sending request")
		return
	}

	result, err = client.ListTransparentDataEncryptionActivityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListTransparentDataEncryptionActivity", resp, "Failure responding to request")
	}

	return
}

// ListTransparentDataEncryptionActivityPreparer prepares the ListTransparentDataEncryptionActivity request.
func (client DatabasesClient) ListTransparentDataEncryptionActivityPreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/current/operationResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListTransparentDataEncryptionActivitySender sends the ListTransparentDataEncryptionActivity request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ListTransparentDataEncryptionActivitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListTransparentDataEncryptionActivityResponder handles the response to the ListTransparentDataEncryptionActivity request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ListTransparentDataEncryptionActivityResponder(resp *http.Response) (result TransparentDataEncryptionActivityListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsages returns database usages.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the database.
func (client DatabasesClient) ListUsages(resourceGroupName string, serverName string, databaseName string) (result DatabaseMetricListResult, err error) {
	req, err := client.ListUsagesPreparer(resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListUsages", resp, "Failure sending request")
		return
	}

	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "ListUsages", resp, "Failure responding to request")
	}

	return
}

// ListUsagesPreparer prepares the ListUsages request.
func (client DatabasesClient) ListUsagesPreparer(resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListUsagesSender sends the ListUsages request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ListUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListUsagesResponder handles the response to the ListUsages request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ListUsagesResponder(resp *http.Response) (result DatabaseMetricListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Pause pauses a data warehouse. This method may poll for completion. Polling
// can be canceled by passing the cancel channel argument. The channel will be
// used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the data warehouse to pause.
func (client DatabasesClient) Pause(resourceGroupName string, serverName string, databaseName string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result autorest.Response
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.PausePreparer(resourceGroupName, serverName, databaseName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Pause", nil, "Failure preparing request")
			return
		}

		resp, err := client.PauseSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Pause", resp, "Failure sending request")
			return
		}

		result, err = client.PauseResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Pause", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// PausePreparer prepares the Pause request.
func (client DatabasesClient) PausePreparer(resourceGroupName string, serverName string, databaseName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/pause", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// PauseSender sends the Pause request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) PauseSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// PauseResponder handles the response to the Pause request. The method always
// closes the http.Response Body.
func (client DatabasesClient) PauseResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Resume resumes a data warehouse. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group that contains the
// resource. You can obtain this value from the Azure Resource Manager API or
// the portal. serverName is the name of the server. databaseName is the name
// of the data warehouse to resume.
func (client DatabasesClient) Resume(resourceGroupName string, serverName string, databaseName string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result autorest.Response
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.ResumePreparer(resourceGroupName, serverName, databaseName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Resume", nil, "Failure preparing request")
			return
		}

		resp, err := client.ResumeSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Resume", resp, "Failure sending request")
			return
		}

		result, err = client.ResumeResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesClient", "Resume", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// ResumePreparer prepares the Resume request.
func (client DatabasesClient) ResumePreparer(resourceGroupName string, serverName string, databaseName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/resume", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ResumeSender sends the Resume request. The method will close the
// http.Response Body if it receives an error.
func (client DatabasesClient) ResumeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ResumeResponder handles the response to the Resume request. The method always
// closes the http.Response Body.
func (client DatabasesClient) ResumeResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusAccepted, http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
