#include "moveTree.h"
#include "viewer.h"
#include "osl/eval/pieceEval.h"

#include <QtGui>
#include <Q3Header>

MoveTree::~MoveTree()
{
}

void MoveTree::buildContextMenu(QMenu *menu)
{
  QAction *expandBestAction = new QAction(tr("Expand Best"), this);
  connect(expandBestAction, SIGNAL(activated()),
	  this, SLOT(expandBest()));
  menu->addAction(expandBestAction);
  QAction *expandAllAction = new QAction(tr("Expand All"), this);
  connect(expandAllAction, SIGNAL(activated()),
	  this, SLOT(expandAll()));
  menu->addAction(expandAllAction);
  QAction *closeAllAction = new QAction(tr("Close All"), this);
  connect(closeAllAction, SIGNAL(activated()),
	  this, SLOT(closeAll()));
  menu->addAction(closeAllAction);

  menu->insertSeparator();
  QAction *moveGenerateAction = new QAction(tr("Show Generated &Moves"), this);
  connect(moveGenerateAction, SIGNAL(activated()),
	  this, SIGNAL(moveGenerate()));
  menu->addAction(moveGenerateAction);
}

void MoveTree::contextMenuEvent(QContextMenuEvent *event)
{
  QMenu menu(this);
  buildContextMenu(&menu);

  if (! selectedItem())
  {
    QPoint pos(event->x(), event->y() - header()->height());
    Q3ListViewItem *item = itemAt(pos);
    if (item)
    {
      setSelected(item, true);
    }
  }
  menu.exec(event->globalPos());
}

void MoveTree::expandAll()
{
  MoveTreeItem *item = (MoveTreeItem *) selectedItem();
  if (!item)
    return;

  for (Q3ListViewItemIterator it(item); it.current(); it++)
  {
    it.current()->setOpen(true);
  }
}

void MoveTree::closeAll()
{
  MoveTreeItem *item = (MoveTreeItem *) selectedItem();
  if (!item)
    return;

  for (Q3ListViewItemIterator it(item); it.current(); it++)
  {
    it.current()->setOpen(false);
  }
}

void MoveTree::expandBest()
{
  expandBestChildren((MoveTreeItem *) selectedItem());
}

void MoveTree::expandBestChildren(MoveTreeItem *item)
{
  if (!item)
    return;

  item->setOpen(true);
  for (MoveTreeItem *child = (MoveTreeItem *)item->firstChild();
       child;
       child = (MoveTreeItem *)child->nextSibling())
  {
    if (child->isBestMove())
    {
      child->setOpen(true);
      expandBestChildren(child);
      break;
    }
  }
}

int MoveTreeItem::compare(Q3ListViewItem *i, int col, bool ascending) const
{
  if (col == 0)
  {
    osl::Move m2 = ((MoveTreeItem *)i)->getMove();
    if ((! move.isNormal()) && (! m2.isNormal()))
      return 0;
    else if (! move.isNormal())
      return -1;
    else if (! m2.isNormal())
      return 1;

    if (move.to().x() < m2.to().x())
      return -1;
    else if (move.to().x() > m2.to().x())
      return 1;
    else
    {
      if (move.to().y() < m2.to().y())
	return -1;
      else if (move.to().y() > m2.to().y())
	return 1;
      else
      {
	int x1 = osl::eval::Ptype_Eval_Table.value(move.ptype()) + osl::eval::Ptype_Eval_Table.value(osl::unpromote(move.ptype()));
	int x2 = osl::eval::Ptype_Eval_Table.value(m2.ptype()) + osl::eval::Ptype_Eval_Table.value(osl::unpromote(m2.ptype()));
	if (x1 < x2)
	  return -1;
	else if (x1 > x2)
	  return 1;
	else return 0;
      }
    }
  }
  else
    return key(col, ascending).compare(i->key(col, ascending));
}
