#define index(i, j, k, l) ((i) + 4 * ((j) + 4 * ((k) + 4 * (l))))

/* order coefficients (i, j, k, l) by i + j + k + l, then i^2 + j^2 + k^2 + l^2 */
cache_align_(static const uchar perm_4[256]) = {
  index(0, 0, 0, 0), /*   0 :  0 */

  index(1, 0, 0, 0), /*   1 :  1 */
  index(0, 1, 0, 0), /*   2 :  1 */
  index(0, 0, 1, 0), /*   3 :  1 */
  index(0, 0, 0, 1), /*   4 :  1 */

  index(1, 1, 0, 0), /*   5 :  2 */
  index(0, 0, 1, 1), /*   6 :  2 */
  index(1, 0, 1, 0), /*   7 :  2 */
  index(0, 1, 0, 1), /*   8 :  2 */
  index(1, 0, 0, 1), /*   9 :  2 */
  index(0, 1, 1, 0), /*  10 :  2 */

  index(2, 0, 0, 0), /*  11 :  2 */
  index(0, 2, 0, 0), /*  12 :  2 */
  index(0, 0, 2, 0), /*  13 :  2 */
  index(0, 0, 0, 2), /*  14 :  2 */

  index(0, 1, 1, 1), /*  15 :  3 */
  index(1, 0, 1, 1), /*  16 :  3 */
  index(1, 1, 0, 1), /*  17 :  3 */
  index(1, 1, 1, 0), /*  18 :  3 */

  index(2, 1, 0, 0), /*  19 :  3 */
  index(2, 0, 1, 0), /*  20 :  3 */
  index(2, 0, 0, 1), /*  21 :  3 */
  index(0, 2, 1, 0), /*  22 :  3 */
  index(0, 2, 0, 1), /*  23 :  3 */
  index(1, 2, 0, 0), /*  24 :  3 */
  index(0, 0, 2, 1), /*  25 :  3 */
  index(1, 0, 2, 0), /*  26 :  3 */
  index(0, 1, 2, 0), /*  27 :  3 */
  index(1, 0, 0, 2), /*  28 :  3 */
  index(0, 1, 0, 2), /*  29 :  3 */
  index(0, 0, 1, 2), /*  30 :  3 */

  index(3, 0, 0, 0), /*  31 :  3 */
  index(0, 3, 0, 0), /*  32 :  3 */
  index(0, 0, 3, 0), /*  33 :  3 */
  index(0, 0, 0, 3), /*  34 :  3 */

  index(1, 1, 1, 1), /*  35 :  4 */

  index(2, 0, 1, 1), /*  36 :  4 */
  index(2, 1, 0, 1), /*  37 :  4 */
  index(2, 1, 1, 0), /*  38 :  4 */
  index(1, 2, 0, 1), /*  39 :  4 */
  index(1, 2, 1, 0), /*  40 :  4 */
  index(0, 2, 1, 1), /*  41 :  4 */
  index(1, 1, 2, 0), /*  42 :  4 */
  index(0, 1, 2, 1), /*  43 :  4 */
  index(1, 0, 2, 1), /*  44 :  4 */
  index(0, 1, 1, 2), /*  45 :  4 */
  index(1, 0, 1, 2), /*  46 :  4 */
  index(1, 1, 0, 2), /*  47 :  4 */

  index(2, 2, 0, 0), /*  48 :  4 */
  index(0, 0, 2, 2), /*  49 :  4 */
  index(2, 0, 2, 0), /*  50 :  4 */
  index(0, 2, 0, 2), /*  51 :  4 */
  index(2, 0, 0, 2), /*  52 :  4 */
  index(0, 2, 2, 0), /*  53 :  4 */

  index(3, 1, 0, 0), /*  54 :  4 */
  index(3, 0, 1, 0), /*  55 :  4 */
  index(3, 0, 0, 1), /*  56 :  4 */
  index(0, 3, 1, 0), /*  57 :  4 */
  index(0, 3, 0, 1), /*  58 :  4 */
  index(1, 3, 0, 0), /*  59 :  4 */
  index(0, 0, 3, 1), /*  60 :  4 */
  index(1, 0, 3, 0), /*  61 :  4 */
  index(0, 1, 3, 0), /*  62 :  4 */
  index(1, 0, 0, 3), /*  63 :  4 */
  index(0, 1, 0, 3), /*  64 :  4 */
  index(0, 0, 1, 3), /*  65 :  4 */

  index(2, 1, 1, 1), /*  66 :  5 */
  index(1, 2, 1, 1), /*  67 :  5 */
  index(1, 1, 2, 1), /*  68 :  5 */
  index(1, 1, 1, 2), /*  69 :  5 */

  index(1, 0, 2, 2), /*  70 :  5 */
  index(1, 2, 0, 2), /*  71 :  5 */
  index(1, 2, 2, 0), /*  72 :  5 */
  index(2, 1, 0, 2), /*  73 :  5 */
  index(2, 1, 2, 0), /*  74 :  5 */
  index(0, 1, 2, 2), /*  75 :  5 */
  index(2, 2, 1, 0), /*  76 :  5 */
  index(0, 2, 1, 2), /*  77 :  5 */
  index(2, 0, 1, 2), /*  78 :  5 */
  index(0, 2, 2, 1), /*  79 :  5 */
  index(2, 0, 2, 1), /*  80 :  5 */
  index(2, 2, 0, 1), /*  81 :  5 */

  index(3, 0, 1, 1), /*  82 :  5 */
  index(3, 1, 0, 1), /*  83 :  5 */
  index(3, 1, 1, 0), /*  84 :  5 */
  index(1, 3, 0, 1), /*  85 :  5 */
  index(1, 3, 1, 0), /*  86 :  5 */
  index(0, 3, 1, 1), /*  87 :  5 */
  index(1, 1, 3, 0), /*  88 :  5 */
  index(0, 1, 3, 1), /*  89 :  5 */
  index(1, 0, 3, 1), /*  90 :  5 */
  index(0, 1, 1, 3), /*  91 :  5 */
  index(1, 0, 1, 3), /*  92 :  5 */
  index(1, 1, 0, 3), /*  93 :  5 */

  index(3, 2, 0, 0), /*  94 :  5 */
  index(3, 0, 2, 0), /*  95 :  5 */
  index(3, 0, 0, 2), /*  96 :  5 */
  index(0, 3, 2, 0), /*  97 :  5 */
  index(0, 3, 0, 2), /*  98 :  5 */
  index(2, 3, 0, 0), /*  99 :  5 */
  index(0, 0, 3, 2), /* 100 :  5 */
  index(2, 0, 3, 0), /* 101 :  5 */
  index(0, 2, 3, 0), /* 102 :  5 */
  index(2, 0, 0, 3), /* 103 :  5 */
  index(0, 2, 0, 3), /* 104 :  5 */
  index(0, 0, 2, 3), /* 105 :  5 */

  index(2, 2, 1, 1), /* 106 :  6 */
  index(1, 1, 2, 2), /* 107 :  6 */
  index(2, 1, 2, 1), /* 108 :  6 */
  index(1, 2, 1, 2), /* 109 :  6 */
  index(2, 1, 1, 2), /* 110 :  6 */
  index(1, 2, 2, 1), /* 111 :  6 */

  index(0, 2, 2, 2), /* 112 :  6 */
  index(2, 0, 2, 2), /* 113 :  6 */
  index(2, 2, 0, 2), /* 114 :  6 */
  index(2, 2, 2, 0), /* 115 :  6 */

  index(3, 1, 1, 1), /* 116 :  6 */
  index(1, 3, 1, 1), /* 117 :  6 */
  index(1, 1, 3, 1), /* 118 :  6 */
  index(1, 1, 1, 3), /* 119 :  6 */

  index(3, 2, 1, 0), /* 120 :  6 */
  index(3, 2, 0, 1), /* 121 :  6 */
  index(3, 0, 2, 1), /* 122 :  6 */
  index(3, 1, 2, 0), /* 123 :  6 */
  index(3, 1, 0, 2), /* 124 :  6 */
  index(3, 0, 1, 2), /* 125 :  6 */
  index(0, 3, 2, 1), /* 126 :  6 */
  index(1, 3, 2, 0), /* 127 :  6 */
  index(1, 3, 0, 2), /* 128 :  6 */
  index(0, 3, 1, 2), /* 129 :  6 */
  index(2, 3, 1, 0), /* 130 :  6 */
  index(2, 3, 0, 1), /* 131 :  6 */
  index(1, 0, 3, 2), /* 132 :  6 */
  index(0, 1, 3, 2), /* 133 :  6 */
  index(2, 1, 3, 0), /* 134 :  6 */
  index(2, 0, 3, 1), /* 135 :  6 */
  index(0, 2, 3, 1), /* 136 :  6 */
  index(1, 2, 3, 0), /* 137 :  6 */
  index(2, 1, 0, 3), /* 138 :  6 */
  index(2, 0, 1, 3), /* 139 :  6 */
  index(0, 2, 1, 3), /* 140 :  6 */
  index(1, 2, 0, 3), /* 141 :  6 */
  index(1, 0, 2, 3), /* 142 :  6 */
  index(0, 1, 2, 3), /* 143 :  6 */

  index(3, 3, 0, 0), /* 144 :  6 */
  index(0, 0, 3, 3), /* 145 :  6 */
  index(3, 0, 3, 0), /* 146 :  6 */
  index(0, 3, 0, 3), /* 147 :  6 */
  index(3, 0, 0, 3), /* 148 :  6 */
  index(0, 3, 3, 0), /* 149 :  6 */

  index(1, 2, 2, 2), /* 150 :  7 */
  index(2, 1, 2, 2), /* 151 :  7 */
  index(2, 2, 1, 2), /* 152 :  7 */
  index(2, 2, 2, 1), /* 153 :  7 */

  index(3, 2, 1, 1), /* 154 :  7 */
  index(3, 1, 2, 1), /* 155 :  7 */
  index(3, 1, 1, 2), /* 156 :  7 */
  index(1, 3, 2, 1), /* 157 :  7 */
  index(1, 3, 1, 2), /* 158 :  7 */
  index(2, 3, 1, 1), /* 159 :  7 */
  index(1, 1, 3, 2), /* 160 :  7 */
  index(2, 1, 3, 1), /* 161 :  7 */
  index(1, 2, 3, 1), /* 162 :  7 */
  index(2, 1, 1, 3), /* 163 :  7 */
  index(1, 2, 1, 3), /* 164 :  7 */
  index(1, 1, 2, 3), /* 165 :  7 */

  index(3, 0, 2, 2), /* 166 :  7 */
  index(3, 2, 0, 2), /* 167 :  7 */
  index(3, 2, 2, 0), /* 168 :  7 */
  index(2, 3, 0, 2), /* 169 :  7 */
  index(2, 3, 2, 0), /* 170 :  7 */
  index(0, 3, 2, 2), /* 171 :  7 */
  index(2, 2, 3, 0), /* 172 :  7 */
  index(0, 2, 3, 2), /* 173 :  7 */
  index(2, 0, 3, 2), /* 174 :  7 */
  index(0, 2, 2, 3), /* 175 :  7 */
  index(2, 0, 2, 3), /* 176 :  7 */
  index(2, 2, 0, 3), /* 177 :  7 */

  index(1, 0, 3, 3), /* 178 :  7 */
  index(1, 3, 0, 3), /* 179 :  7 */
  index(1, 3, 3, 0), /* 180 :  7 */
  index(3, 1, 0, 3), /* 181 :  7 */
  index(3, 1, 3, 0), /* 182 :  7 */
  index(0, 1, 3, 3), /* 183 :  7 */
  index(3, 3, 1, 0), /* 184 :  7 */
  index(0, 3, 1, 3), /* 185 :  7 */
  index(3, 0, 1, 3), /* 186 :  7 */
  index(0, 3, 3, 1), /* 187 :  7 */
  index(3, 0, 3, 1), /* 188 :  7 */
  index(3, 3, 0, 1), /* 189 :  7 */

  index(2, 2, 2, 2), /* 190 :  8 */

  index(3, 1, 2, 2), /* 191 :  8 */
  index(3, 2, 1, 2), /* 192 :  8 */
  index(3, 2, 2, 1), /* 193 :  8 */
  index(2, 3, 1, 2), /* 194 :  8 */
  index(2, 3, 2, 1), /* 195 :  8 */
  index(1, 3, 2, 2), /* 196 :  8 */
  index(2, 2, 3, 1), /* 197 :  8 */
  index(1, 2, 3, 2), /* 198 :  8 */
  index(2, 1, 3, 2), /* 199 :  8 */
  index(1, 2, 2, 3), /* 200 :  8 */
  index(2, 1, 2, 3), /* 201 :  8 */
  index(2, 2, 1, 3), /* 202 :  8 */

  index(3, 3, 1, 1), /* 203 :  8 */
  index(1, 1, 3, 3), /* 204 :  8 */
  index(3, 1, 3, 1), /* 205 :  8 */
  index(1, 3, 1, 3), /* 206 :  8 */
  index(3, 1, 1, 3), /* 207 :  8 */
  index(1, 3, 3, 1), /* 208 :  8 */

  index(2, 0, 3, 3), /* 209 :  8 */
  index(2, 3, 0, 3), /* 210 :  8 */
  index(2, 3, 3, 0), /* 211 :  8 */
  index(3, 2, 0, 3), /* 212 :  8 */
  index(3, 2, 3, 0), /* 213 :  8 */
  index(0, 2, 3, 3), /* 214 :  8 */
  index(3, 3, 2, 0), /* 215 :  8 */
  index(0, 3, 2, 3), /* 216 :  8 */
  index(3, 0, 2, 3), /* 217 :  8 */
  index(0, 3, 3, 2), /* 218 :  8 */
  index(3, 0, 3, 2), /* 219 :  8 */
  index(3, 3, 0, 2), /* 220 :  8 */

  index(3, 2, 2, 2), /* 221 :  9 */
  index(2, 3, 2, 2), /* 222 :  9 */
  index(2, 2, 3, 2), /* 223 :  9 */
  index(2, 2, 2, 3), /* 224 :  9 */

  index(2, 1, 3, 3), /* 225 :  9 */
  index(2, 3, 1, 3), /* 226 :  9 */
  index(2, 3, 3, 1), /* 227 :  9 */
  index(3, 2, 1, 3), /* 228 :  9 */
  index(3, 2, 3, 1), /* 229 :  9 */
  index(1, 2, 3, 3), /* 230 :  9 */
  index(3, 3, 2, 1), /* 231 :  9 */
  index(1, 3, 2, 3), /* 232 :  9 */
  index(3, 1, 2, 3), /* 233 :  9 */
  index(1, 3, 3, 2), /* 234 :  9 */
  index(3, 1, 3, 2), /* 235 :  9 */
  index(3, 3, 1, 2), /* 236 :  9 */

  index(0, 3, 3, 3), /* 237 :  9 */
  index(3, 0, 3, 3), /* 238 :  9 */
  index(3, 3, 0, 3), /* 239 :  9 */
  index(3, 3, 3, 0), /* 240 :  9 */

  index(3, 3, 2, 2), /* 241 : 10 */
  index(2, 2, 3, 3), /* 242 : 10 */
  index(3, 2, 3, 2), /* 243 : 10 */
  index(2, 3, 2, 3), /* 244 : 10 */
  index(3, 2, 2, 3), /* 245 : 10 */
  index(2, 3, 3, 2), /* 246 : 10 */

  index(1, 3, 3, 3), /* 247 : 10 */
  index(3, 1, 3, 3), /* 248 : 10 */
  index(3, 3, 1, 3), /* 249 : 10 */
  index(3, 3, 3, 1), /* 250 : 10 */

  index(2, 3, 3, 3), /* 251 : 11 */
  index(3, 2, 3, 3), /* 252 : 11 */
  index(3, 3, 2, 3), /* 253 : 11 */
  index(3, 3, 3, 2), /* 254 : 11 */

  index(3, 3, 3, 3), /* 255 : 12 */
};

#undef index
