; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; REQUIRES: x86-registered-target
; RUN: opt < %s -passes=rel-lookup-table-converter -relocation-model=pic -S | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

@a = internal constant i32 0, align 4
@b = internal constant i32 0, align 4
@c = internal constant i32 0, align 4

@table1 = private unnamed_addr constant [3 x ptr] [ptr @a, ptr @b, ptr @c], align 8
@table2 = private unnamed_addr constant [3 x ptr] [ptr @a, ptr @b, ptr @c], align 8
@table3 = private unnamed_addr constant [3 x ptr] [ptr @a, ptr @b, ptr @c], align 8

define ptr @test(i32 %cond) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    [[RELTABLE_SHIFT:%.*]] = shl i32 [[COND:%.*]], 2
; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = call ptr @llvm.load.relative.i32(ptr @reltable.test, i32 [[RELTABLE_SHIFT]])
; CHECK-NEXT:    ret ptr [[RELTABLE_INTRINSIC]]
;
  %switch.gep = getelementptr inbounds [3 x ptr], ptr @table1, i32 0, i32 %cond
  %switch.load = load ptr, ptr %switch.gep, align 8
  ret ptr %switch.load
}

define i32 @test_different_load_type(i32 %cond) {
; CHECK-LABEL: @test_different_load_type(
; CHECK-NEXT:    [[SWITCH_GEP:%.*]] = getelementptr inbounds [3 x ptr], ptr @table2, i32 0, i32 [[COND:%.*]]
; CHECK-NEXT:    [[SWITCH_LOAD:%.*]] = load i32, ptr [[SWITCH_GEP]], align 8
; CHECK-NEXT:    ret i32 [[SWITCH_LOAD]]
;
  %switch.gep = getelementptr inbounds [3 x ptr], ptr @table2, i32 0, i32 %cond
  %switch.load = load i32, ptr %switch.gep, align 8
  ret i32 %switch.load
}

define i8 @test_different_gep_type(i32 %cond) {
; CHECK-LABEL: @test_different_gep_type(
; CHECK-NEXT:    [[SWITCH_GEP:%.*]] = getelementptr inbounds [3 x i8], ptr @table3, i32 0, i32 [[COND:%.*]]
; CHECK-NEXT:    [[SWITCH_LOAD:%.*]] = load i8, ptr [[SWITCH_GEP]], align 8
; CHECK-NEXT:    ret i8 [[SWITCH_LOAD]]
;
  %switch.gep = getelementptr inbounds [3 x i8], ptr @table3, i32 0, i32 %cond
  %switch.load = load i8, ptr %switch.gep, align 8
  ret i8 %switch.load
}

!llvm.module.flags = !{!0, !1}
!0 = !{i32 7, !"PIC Level", i32 2}
!1 = !{i32 1, !"Code Model", i32 1}
!4 = !{!"any pointer", !5, i64 0}
!5 = !{!"omnipotent char", !6, i64 0}
!6 = !{!"Simple C/C++ TBAA"}
