/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.io;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.mysqlx.MysqlxError;
import com.mysql.cj.mysqlx.io.MessageConstants;
import com.mysql.cj.mysqlx.io.MessageReader;
import com.mysql.cj.mysqlx.protobuf.Mysqlx;
import com.mysql.cj.mysqlx.protobuf.MysqlxNotice;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AsyncMessageReader
implements CompletionHandler<Integer, Void>,
MessageReader {
    private int messageSize;
    private int messageType;
    private ByteBuffer headerBuf = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN);
    private ByteBuffer messageBuf;
    private AsynchronousSocketChannel channel;
    private MessageListener currentMessageListener;
    private BlockingQueue<MessageListener> messageListenerQueue = new LinkedBlockingQueue<MessageListener>();
    private CompletableFuture<Class<? extends GeneratedMessage>> pendingMsgClass;
    private Object pendingMsgMonitor = new Object();
    private ReadingState state;

    public AsyncMessageReader(AsynchronousSocketChannel channel) {
        this.channel = channel;
    }

    public void start() {
        this.readHeader();
    }

    public void pushMessageListener(MessageListener l2) {
        if (!this.channel.isOpen()) {
            throw new CJCommunicationsException("async closed");
        }
        this.messageListenerQueue.add(l2);
    }

    private MessageListener getMessageListener(boolean block) {
        if (this.currentMessageListener == null) {
            if (block) {
                try {
                    this.currentMessageListener = this.messageListenerQueue.take();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.currentMessageListener = (MessageListener)this.messageListenerQueue.poll();
            }
        }
        return this.currentMessageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader() {
        this.state = ReadingState.READING_HEADER;
        if (this.headerBuf.position() < 5) {
            this.channel.read(this.headerBuf, null, this);
            return;
        }
        this.headerBuf.clear();
        this.messageSize = this.headerBuf.getInt() - 1;
        this.messageType = this.headerBuf.get();
        this.headerBuf.clear();
        this.state = ReadingState.READING_MESSAGE;
        this.messageBuf = ByteBuffer.allocate(this.messageSize);
        AsyncMessageReader asyncMessageReader = this;
        synchronized (asyncMessageReader) {
            this.channel.read(this.messageBuf, null, this);
        }
    }

    private void readMessage() {
        if (this.messageBuf.position() < this.messageSize) {
            this.channel.read(this.messageBuf, null, this);
            return;
        }
        int type = this.messageType;
        ByteBuffer buf = this.messageBuf;
        this.messageType = 0;
        this.messageBuf = null;
        Class<? extends GeneratedMessage> messageClass = MessageConstants.MESSAGE_TYPE_TO_CLASS.get(type);
        if (messageClass == null) {
            Mysqlx.ServerMessages.Type serverMessageMapping = Mysqlx.ServerMessages.Type.valueOf(type);
            throw AssertionFailedException.shouldNotHappen("Unknown message type: " + type + " (server messages mapping: " + (Object)((Object)serverMessageMapping) + ")");
        }
        this.dispatchMessage(messageClass, this.parseMessage(messageClass, buf));
        this.readHeader();
    }

    private GeneratedMessage parseMessage(Class<? extends GeneratedMessage> messageClass, ByteBuffer buf) {
        try {
            Parser<? extends GeneratedMessage> parser = MessageConstants.MESSAGE_CLASS_TO_PARSER.get(messageClass);
            buf.clear();
            return (GeneratedMessage)parser.parseFrom(CodedInputStream.newInstance((ByteBuffer)buf));
        }
        catch (InvalidProtocolBufferException ex) {
            throw AssertionFailedException.shouldNotHappen((Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessage(Class<? extends GeneratedMessage> messageClass, GeneratedMessage message) {
        Object object;
        if (messageClass == MysqlxNotice.Frame.class && ((MysqlxNotice.Frame)message).getScope() == MysqlxNotice.Frame.Scope.GLOBAL) {
            throw new RuntimeException("TODO: implement me");
        }
        if (this.getMessageListener(false) == null) {
            object = this.pendingMsgMonitor;
            synchronized (object) {
                this.pendingMsgClass = CompletableFuture.completedFuture(messageClass);
                this.pendingMsgMonitor.notify();
            }
        }
        this.getMessageListener(true);
        object = this.pendingMsgMonitor;
        synchronized (object) {
            boolean currentListenerDone = (Boolean)this.currentMessageListener.apply(messageClass, message);
            if (currentListenerDone) {
                this.currentMessageListener = null;
            }
            this.pendingMsgClass = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(Integer bytesRead, Void v) {
        if (bytesRead < 0) {
            try {
                this.channel.close();
            }
            catch (IOException ex) {
                throw AssertionFailedException.shouldNotHappen(ex);
            }
            finally {
                if (this.currentMessageListener == null) {
                    this.currentMessageListener = (MessageListener)this.messageListenerQueue.poll();
                }
                if (this.currentMessageListener != null) {
                    this.currentMessageListener.closed();
                }
                this.currentMessageListener = null;
            }
            return;
        }
        try {
            if (this.state == ReadingState.READING_HEADER) {
                this.readHeader();
            } else {
                this.readMessage();
            }
        }
        catch (Throwable t) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currentMessageListener != null) {
                try {
                    this.currentMessageListener.error(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.messageListenerQueue.forEach(l2 -> {
                try {
                    l2.error(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Object object = this.pendingMsgMonitor;
            synchronized (object) {
                this.pendingMsgClass = new CompletableFuture();
                this.pendingMsgClass.completeExceptionally(t);
                this.pendingMsgMonitor.notify();
            }
            this.messageListenerQueue.clear();
        }
    }

    @Override
    public void failed(Throwable exc, Void v) {
        if (this.getMessageListener(false) != null) {
            if (AsynchronousCloseException.class.equals(exc.getClass())) {
                this.currentMessageListener.closed();
            } else {
                this.currentMessageListener.error(exc);
            }
        }
        this.currentMessageListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends GeneratedMessage> getNextMessageClass() {
        Object object = this.pendingMsgMonitor;
        synchronized (object) {
            while (this.pendingMsgClass == null) {
                try {
                    this.pendingMsgMonitor.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            CompletableFuture<Class<? extends GeneratedMessage>> clazzF = this.pendingMsgClass;
        }
        try {
            Class<? extends GeneratedMessage> clazz = this.pendingMsgClass.get();
            if (Mysqlx.Error.class.equals(clazz)) {
                this.read(clazz);
            }
            return clazz;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new CJCommunicationsException(ex);
        }
    }

    @Override
    public <T extends GeneratedMessage> T read(Class<T> expectedClass) {
        SyncReader<T> r2 = new SyncReader<T>(this, expectedClass);
        return (T)((GeneratedMessage)r2.read());
    }

    private static final class SyncReader<T>
    implements MessageListener {
        private CompletableFuture<Function<BiFunction<Class<? extends GeneratedMessage>, GeneratedMessage, T>, T>> future = new CompletableFuture();
        private Class<T> expectedClass;

        public SyncReader(AsyncMessageReader rdr, Class<T> expectedClass) {
            this.expectedClass = expectedClass;
            rdr.pushMessageListener(this);
        }

        @Override
        public Boolean apply(Class<? extends GeneratedMessage> msgClass, GeneratedMessage msg) {
            this.future.complete(c2 -> c2.apply(msgClass, msg));
            return true;
        }

        @Override
        public void error(Throwable ex) {
            this.future.completeExceptionally(ex);
        }

        public T read() {
            try {
                return ((CompletableFuture)this.future.thenApply(f2 -> f2.apply((msgClass, msg) -> {
                    if (Mysqlx.Error.class.equals(msgClass)) {
                        throw new MysqlxError((Mysqlx.Error)Mysqlx.Error.class.cast(msg));
                    }
                    if (!msgClass.equals(this.expectedClass)) {
                        throw new WrongArgumentException("Unexpected message class. Expected '" + this.expectedClass.getSimpleName() + "' but actually received '" + msgClass.getSimpleName() + "'");
                    }
                    return this.expectedClass.cast(msg);
                }))).get();
            }
            catch (ExecutionException ex) {
                if (MysqlxError.class.equals(ex.getCause().getClass())) {
                    throw new MysqlxError((MysqlxError)ex.getCause());
                }
                throw new CJCommunicationsException(ex);
            }
            catch (InterruptedException ex) {
                throw new CJCommunicationsException(ex);
            }
        }
    }

    private static enum ReadingState {
        READING_HEADER,
        READING_MESSAGE;

    }

    @FunctionalInterface
    public static interface MessageListener
    extends BiFunction<Class<? extends GeneratedMessage>, GeneratedMessage, Boolean> {
        default public void closed() {
        }

        default public void error(Throwable ex) {
            ex.printStackTrace();
        }
    }
}

