CDECK  ID>, HWHREM.
*CMZ :-        -01/06/94  17.03.31  by  Mike Seymour
*-- Author :    Mike Seymour
C-----------------------------------------------------------------------
      SUBROUTINE HWHREM(IBEAM,ITARG)
C-----------------------------------------------------------------------
C     IDENTIFY THE REMNANTS OF THE HARD SCATTERING
C     AND BREAK THEIR COLOUR CONNECTION IF NECESSARY
C-----------------------------------------------------------------------
      INCLUDE 'HERWIG59.INC'
      DOUBLE PRECISION PCL(5)
      INTEGER IBEAM,ITARG,IHEP,NTEMP,I,ICOL,IANT
      LOGICAL LTEMP,T,COL,ANT
      PARAMETER (T=.TRUE.)
      COL(I)=I.EQ.13 .OR. I.GE.1.AND.I.LE.6 .OR. I.GE.115.AND.I.LE.120
      ANT(I)=I.EQ.13 .OR. I.GE.7.AND.I.LE.12.OR. I.GE.109.AND.I.LE.114
C---LOOK FOR UNTREATED BEAM AND TARGET REMNANTS
      IBEAM=0
      ITARG=0
      DO 10 IHEP=1,NHEP
        IF (ISTHEP(IHEP).EQ.148) THEN
          IF (ITARG.NE.0) CALL HWWARN('HWHREM',100,*999)
          ITARG=IHEP
        ELSEIF (ISTHEP(IHEP).EQ.147) THEN
          IF (IBEAM.NE.0) CALL HWWARN('HWHREM',101,*999)
          IBEAM=IHEP
        ENDIF
  10  CONTINUE
      IF (ITARG.EQ.0) CALL HWWARN('HWHREM',102,*999)
      IF (IBEAM.EQ.0) CALL HWWARN('HWHREM',103,*999)
C---IF THEY ARE COLOUR CONNECTED, DISCONNECT THEM BY EMITTING A SOFT
C   GLUON AND SPLITTING THAT GLUON TO LIGHT QUARKS
C  (WHICH NORMALLY GETS DONE AS THE FIRST STAGE OF CLUSTER FORMATION)
C---LOOP OVER COLOUR/ANTICOLOUR LINE
      DO 20 I=1,2
        IF (I.EQ.1) THEN
          ICOL=IBEAM
          IANT=ITARG
        ELSE
          ICOL=ITARG
          IANT=IBEAM
        ENDIF
        IF (COL(IDHW(ICOL)).AND.ANT(IDHW(IANT)).AND.
     $       JMOHEP(2,ICOL).EQ.IANT.AND.JDAHEP(2,IANT).EQ.ICOL) THEN
          CALL HWVSUM(4,PHEP(1,ICOL),PHEP(1,IANT),PCL)
          CALL HWUMAS(PCL)
          NTEMP=NHEP
          CALL HWCCUT(ICOL,IANT,PCL,T,LTEMP)
C---IF NOTHING WAS CREATED THEY MUST BE BELOW THRESHOLD, SO GIVE UP
          IF (NHEP.NE.NTEMP+2) RETURN
C---RELABEL THEM AS PERTUBATIVE JUST TO NEATEN UP THE EVENT RECORD
          ISTHEP(NHEP-1)=149
          ISTHEP(NHEP)=149
        ENDIF
 20   CONTINUE
 999  END
