/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQSymbolWidget_H
#define MvQSymbolWidget_H

#include <QAbstractItemModel>
#include <QListView>
#include <QSettings>
#include <QSortFilterProxyModel>
#include <QWidget>

class QComboBox;
class QVBoxLayout;
class MvQFeatureType;
class MgQPlotScene;

class MvQFeatureListProxyModel : public QSortFilterProxyModel
{
public:
    MvQFeatureListProxyModel(QString group, QObject* parent);
    void setSubGroup(QString subGroup);

protected:
    bool filterAcceptsRow(int source_column, const QModelIndex& source_parent) const;

    QString group_;
    QString subGroup_;
};

//----------------------------------------------------------------------

class MvQFeatureListModel : public QAbstractItemModel
{
public:
   MvQFeatureListModel(QString group, QObject* parent);

   enum {SubGroupRole = Qt::UserRole+1};

   int columnCount (const QModelIndex&) const;
   int rowCount (const QModelIndex& parent = QModelIndex()) const;
   QVariant data (const QModelIndex&, int role = Qt::DisplayRole) const;
   QModelIndex index (int, int, const QModelIndex& parent = QModelIndex()) const;
   QModelIndex parent (const QModelIndex&) const;

   MvQFeatureType* indexToItem (const QModelIndex&) const;

protected:
   QString group_;
};

//----------------------------------------------------------------------

class MvQFeatureListView : public QListView
{
    Q_OBJECT
public:
    MvQFeatureListView (MvQFeatureListModel*,  MvQFeatureListProxyModel*, bool, QWidget *parent=0);

protected slots:
    void slotClicked(const QModelIndex &current);
    void delayedAdjustHeight();

signals:
    void featureSelected(QString);

protected:
   void resizeEvent(QResizeEvent* e);

   MvQFeatureListModel* model_;
   MvQFeatureListProxyModel* proxyModel_;
   MvQFeatureType *dragItem_;
   QPoint startPos_;
   bool autoAdjustHeight_{false};
};

class MvQWmoFeatureWidget : public QWidget
{
Q_OBJECT

public:
   explicit MvQWmoFeatureWidget(QString groupId, QWidget *parent=0);
   ~MvQWmoFeatureWidget() {}

    void writeSettings(QSettings& settings);
    void readSettings(QSettings& settings);

protected slots:
    void subGroupSelected(int);

signals:
    void featureSelected(QString);

protected:
    MvQFeatureListProxyModel* proxyModel_;
    MvQFeatureListView* view_;
    QComboBox* selectorW_;
};


class MvQFeatureWidget : public QWidget
{
Q_OBJECT

public:
   explicit MvQFeatureWidget(QWidget *parent=0);
   ~MvQFeatureWidget() {}

   void writeSettings(QSettings& settings);
   void readSettings(QSettings& settings);

signals:
    void featureSelected(QString);

protected:
   void buildGroup(const std::string& grId, const std::string& grLabel);

   QVBoxLayout* layout_{nullptr};
   MvQWmoFeatureWidget* wmoW_{nullptr};
};

#endif
