/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "fontloader.h"
#include "logger.h"

#include <QDir>
#include <QFontDatabase>

namespace {
Logger logger(LOG_MAIN, "FontLoader");
}

// static
void FontLoader::loadFonts() {
  QDir dir(":/ui/resources/fonts");
  QStringList files = dir.entryList();
  for (const QString& file : files) {
    logger.log() << "Loading font:" << file;
    int id = QFontDatabase::addApplicationFont(":/ui/resources/fonts/" + file);
    logger.log() << "Result:" << id;
  }
}
