#
#VID c73305ae-8cd7-11d9-9873-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52166);
 script_cve_id("CVE-2005-0611");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.1");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: linux-realplayer";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: linux-realplayer

CVE-2005-0611
Heap-based buffer overflow in RealNetworks RealPlayer 10.5
(6.0.12.1056 and earlier), 10, 8, and RealOne Player V2 and V1, allows
remote attackers to execute arbitrary code via .WAV files.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://service.real.com/help/faq/security/050224_player/EN/
http://marc.theaimsgroup.com/?l=vulnwatch&m=110977858619314
http://www.vuxml.org/freebsd/c73305ae-8cd7-11d9-9873-000a95bc6fae.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: linux-realplayer";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"linux-realplayer");
if(!isnull(bver) && revcomp(a:bver, b:"10.0.2")<=0) {
    security_note(0, data:"Package linux-realplayer version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
