##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_golden_ftp_server_detect.nasl 6053 2009-12-04 17:05:29Z dec $
#
# Golden FTP Server Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(801072);
  script_version ("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Golden FTP Server Version Detection");
  desc = "
  Overview: This script determines Golden FTP server version on the
  remote host and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Sets KB for Golden FTP server version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port:port);
if(isnull(banner)){
  exit(0);
}

if("220 Golden FTP Server Pro" >< banner)
{
  gftpVer = eregmatch(pattern:"v([0-9.]+)", string:banner);
  if(gftpVer[1] != NULL)
  {
    set_kb_item(name:"Golden/FTP/Pro/Ver", value:gftpVer[1]);
    security_note(data:"Golden FTP Pro version " + gftpVer[1] + 
                       " was detected on the host");
    break;
  }
}

if(("220 Golden FTP Server" >< banner) && ("Pro"  >!<  banner))
{
  gfftpVer = eregmatch(pattern:"v([0-9.]+)", string:banner);
  if(gfftpVer[1] != NULL){
  
    set_kb_item(name:"Golden/FTP/Free/Ver", value:gfftpVer[1]);
    security_note(data:"Golden FTP Free version " + gfftpVer[1] +         
                       " was detected on the host");
  }
}
