###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sonic_spot_audioactive_player_detect.nasl 2567 2009-06-01 10:45:02Z jun $
#
# Sonic Spot Audioactive Player Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800571);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Sonic Spot Audioactive Player Version Detection");
  desc = "
  Overview: This script detects the version of Sonic Spot Audioactive Player
  and sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of Sonic Spot Audioactive Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}
key = "SOFTWARE\Telos Systems\Audioactive Player";
if(!registry_key_exists(key:key))exit(0);

foreach item (registry_enum_keys(key:key))
{
  audioactiveVer = eregmatch(pattern:"[0-9.]+[a-z]?", string:item);
  if(audioactiveVer != NULL)
  {
    set_kb_item(name:"SonicSpot/Audoiactive/Player/Ver", value:audioactiveVer[0]);
    security_note(data:"Sonic Spot Audioactive Player version " + audioactiveVer[0] +
                    " was detected on the host");
    exit(0);
  }
}
