###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms10-014.nasl 7185 2010-02-10 09:14:35Z feb $
#
# Microsoft Kerberos Denial of Service Vulnerability (977290)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902115);
  script_version("$Revision: 7541 $:1.0");
  script_tag(name:"cvss_base", value:"6.3");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2010-0035");
  script_bugtraq_id(38110);
  script_name("Microsoft Kerberos Denial of Service Vulnerability (977290)");
  desc = "
  Overview: This host has critical security update missing according to Microsoft
  Bulletin MS10-014.

  Vulnerability Insight:
  The issue is caused by a NULL pointer dereference error when handling
  'Ticket-Granting-Ticket' renewal requests sent by a client on a remote
   non-Windows realm in a mixed-mode Kerberos implementation.

  Impact:
  Successful exploitation could allow remote attackers to cause a vulnerable
  Windows domain controller to stop responding.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2000 Service Pack 4 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms10-014.mspx

  References:
  http://www.vupen.com/english/advisories/2010/0344
  http://www.microsoft.com/technet/security/bulletin/ms10-014.mspx

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the vulnerable DLL file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for MS10-014 Hotfix
if(hotfix_missing(name:"977290") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Kdcsvc.dll");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Kdcsvc.dll version < 5.0.2195.7361
  if(version_is_less(version:sysVer, test_version:"5.0.2195.7361")){
    security_hole(0);
  }
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Kdcsvc.dll version <  5.2.3790.4628
    if(version_is_less(version:sysVer, test_version:"5.2.3790.4628")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
