///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <iostream>

// Include the Boost.Python library.
#include <boost/python.hpp>
#include <boost/python/to_python_converter.hpp>
#include <boost/python/object.hpp>
#include <boost/python/handle.hpp>

int main(int argc, char** argv) 
{
	std::cout << "Python Program Name: " << Py_GetProgramName() << std::endl;
	std::cout << "Python Program Full Path: " << Py_GetProgramFullPath() << std::endl;
	std::cout << "Python Prefix: " << Py_GetPrefix() << std::endl;
	std::cout << "Python Exec Prefix: " << Py_GetExecPrefix() << std::endl;
	std::cout << "Python Path: " << Py_GetPath() << std::endl;
	
	Py_Initialize();

	using namespace boost::python;

	object main_module = object(handle< >(borrowed(PyImport_AddModule("__main__"))));
	object main_namespace = object(handle< >(borrowed(PyModule_GetDict(main_module.ptr()))));
	object sys_module = object(handle< >(PyImport_ImportModule("sys")));
	object sys_namespace = object(handle< >(borrowed(PyModule_GetDict(sys_module.ptr()))));

	// Make a copy of the initial main namespace. The original namespace dictionary
	// is not touched by the script.
	object main_namespace_copy(handle<>(PyDict_Copy(main_namespace.ptr())));

	// Run the user script.
	handle<> ignored2((PyRun_String(
		"print \"Hello World\"", Py_file_input, 
		main_namespace_copy.ptr(), main_namespace_copy.ptr())));
	
	Py_Finalize();
	
	return 0;
}
