# Try to find the FFTW3 library
#  FFTW3_FOUND - system has FFTW3 lib
#  FFTW3_INCLUDE_DIRS - the include directories needed
#  FFTW3_LIBRARIES - libraries needed

FIND_PATH(FFTW3_INCLUDE_DIR NAMES fftw3.h)
IF(OVITO_DOUBLE_PRECISION_FP)
    FIND_LIBRARY(FFTW3_LIBRARY NAMES fftw3 libfftw3)
ELSE()
    FIND_LIBRARY(FFTW3_LIBRARY NAMES fftw3f libfftw3f)
ENDIF()

SET(FFTW3_INCLUDE_DIRS ${FFTW3_INCLUDE_DIR})
SET(FFTW3_LIBRARIES ${FFTW3_LIBRARY})

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(FFTW3 DEFAULT_MSG FFTW3_LIBRARY FFTW3_INCLUDE_DIR)

MARK_AS_ADVANCED(FFTW3_INCLUDE_DIR FFTW3_LIBRARY)
